package net.sf.cuf.appevent;

import java.util.EventObject;

/**
 * AppEvent is the base class of all events that use the AppEvent
 * mechanism. AppEvents decouple a event sender and a event receiver,
 * see {@link AppEventSupport}, {@link AppEventManager} and
 * {@link BindEvent} for more details on the dispatch possibilities.
 */
public class AppEvent extends EventObject
{
    /** true: the event got consumed, false otherwise. */
    private boolean mIsConsumed;

    /**
     * Create a non-consumed event.
     * @param pSource null or event source
     */
    public AppEvent(final Object pSource)
    {
        super(pSource);
        mIsConsumed= false;
    }

    /**
     * Returns of this event was consumed, may be used e.g. to stop
     * propagation of the event.
     * @return true if the event got consumed, false otherwise
     */
    public boolean isConsumed()
    {
        return mIsConsumed;
    }

    /**
     * Consume the event.
     */
    public void consume()
    {
        mIsConsumed= true;
    }

    /**
     * The method is called once at each step during processing.
     * This can be used in a sub-class that the event consumes itself
     * to stop propagating.
     */
    public void forward()
    {
    }

    /**
     * Returns a String representation of this EventObject.
     *
     * @return  A a String representation of this EventObject.
     */
    public String toString()
    {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("[isConsumed= ");
        sb.append(mIsConsumed);
        sb.append(']');
        return sb.toString();
    }
}
