/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.xfer;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.cuf.xfer.DispatchTarget;
import net.sf.cuf.xfer.Response;

public class DefaultDispatchTarget
implements DispatchTarget {
    private Object mTargetObject;
    private Method mTargetMethod;

    @Override
    public void setTarget(Object pTargetObject, String pMethodName) throws IllegalArgumentException {
        Method method;
        if (pTargetObject == null) {
            throw new IllegalArgumentException("pTargetObject must not be null");
        }
        if (pMethodName == null) {
            throw new IllegalArgumentException("pMethodName must not be null");
        }
        if (!Modifier.isPublic(pTargetObject.getClass().getModifiers())) {
            throw new IllegalArgumentException("pTargetObject must be an object from a public class");
        }
        Class[] params = new Class[]{Response.class};
        try {
            method = pTargetObject.getClass().getMethod(pMethodName, params);
        }
        catch (NoSuchMethodException e) {
            IllegalArgumentException ex = new IllegalArgumentException("No method: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        this.mTargetObject = pTargetObject;
        this.mTargetMethod = method;
    }

    @Override
    public Object getTargetObject() {
        return this.mTargetObject;
    }

    @Override
    public Method getTargetMethod() {
        return this.mTargetMethod;
    }

    public boolean equals(Object pObject) {
        if (pObject == this) {
            return true;
        }
        if (!(pObject instanceof DefaultDispatchTarget)) {
            return false;
        }
        DefaultDispatchTarget target = (DefaultDispatchTarget)pObject;
        if (target.mTargetObject != this.mTargetObject) {
            return false;
        }
        if (this.mTargetMethod == null) {
            return target.mTargetMethod == null;
        }
        return target.mTargetMethod.getName().equals(this.mTargetMethod.getName());
    }

    public int hashCode() {
        return this.mTargetObject.hashCode() | this.mTargetMethod.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("[targetObject=");
        sb.append(this.mTargetObject);
        sb.append(",targetMethod=");
        sb.append(this.mTargetMethod);
        sb.append(']');
        return sb.toString();
    }
}

