/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.fw2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.cuf.appevent.AppEvent;
import net.sf.cuf.appevent.AppEventSupport;
import net.sf.cuf.appevent.AppEventUtil;
import net.sf.cuf.fw.Application;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw2.CloseDialogEvent;
import net.sf.cuf.fw2.DialogDescription;
import net.sf.cuf.fw2.Disposable;
import net.sf.cuf.fw2.OpenDialogEvent;
import net.sf.cuf.fw2.SimpleLifeCycle;

public class DialogManager
implements Disposable {
    private Map<String, DialogDescription> mKnownDialogs;
    private Application mApp;
    private Map<Dc, OpenDialogEvent> mInActivateDialogs;
    private List<Dc> mActiveDialogs;
    private DialogCallback mCallback;

    DialogManager(Application pApp) {
        if (pApp == null) {
            throw new IllegalArgumentException("Application must not be null");
        }
        this.mKnownDialogs = Collections.emptyMap();
        this.mApp = pApp;
        this.mInActivateDialogs = new HashMap<Dc, OpenDialogEvent>();
        this.mActiveDialogs = new ArrayList<Dc>();
    }

    public void setKnownDialogs(Map<String, DialogDescription> pKnownDialogs) {
        if (pKnownDialogs == null) {
            throw new IllegalArgumentException("know dialog map must not be null");
        }
        Iterator<Map.Entry<String, DialogDescription>> i = pKnownDialogs.entrySet().iterator();
        try {
            while (i.hasNext()) {
                Map.Entry<String, DialogDescription> entry = i.next();
                String dialogID = entry.getKey();
                DialogDescription dialogDescription = entry.getValue();
                if (dialogID != null && dialogDescription != null) continue;
                throw new IllegalArgumentException("know dialog map must not contain null values");
            }
        }
        catch (ClassCastException e) {
            IllegalArgumentException iae = new IllegalArgumentException("invalid dialog map");
            iae.initCause(e);
            throw iae;
        }
        this.mKnownDialogs = new HashMap<String, DialogDescription>(pKnownDialogs);
    }

    public void setCallback(DialogCallback pCallback) {
        this.mCallback = pCallback;
    }

    public Dc getActiveDialog() {
        int size = this.mActiveDialogs.size();
        if (size > 0) {
            return this.mActiveDialogs.get(size - 1);
        }
        return null;
    }

    public List<Dc> getActiveDialogs() {
        return new ArrayList<Dc>(this.mActiveDialogs);
    }

    public void openDialog(OpenDialogEvent pEvent) {
        this.openDialog(pEvent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDialog(OpenDialogEvent pEvent, Dc pParent) {
        Dc dc;
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("Application", this.mApp);
        args.putAll(pEvent.getDialogArguments());
        if (pEvent.hasDialogId()) {
            String dialogId = pEvent.getDialogId();
            DialogDescription description = this.mKnownDialogs.get(dialogId);
            if (description == null) {
                return;
            }
            dc = description.getDc();
            if (dc == null) {
                Class<? extends Dc> c = description.getDialogClass();
                try {
                    dc = c.newInstance();
                    dc.init(pParent, args);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            dc = pEvent.getDialog();
        }
        if (dc instanceof SimpleLifeCycle) {
            this.mInActivateDialogs.put(dc, pEvent);
            this.mActiveDialogs.add(dc);
            try {
                ((SimpleLifeCycle)((Object)dc)).doActivate(args);
            }
            finally {
                this.mInActivateDialogs.remove(dc);
            }
        }
        if (this.mCallback != null) {
            this.mCallback.dialogOpened(dc, args);
        }
        pEvent.consume();
    }

    public void closeDialog(CloseDialogEvent pEvent) {
        Dc dc = pEvent.getDialog();
        if (!this.mActiveDialogs.contains(dc)) {
            return;
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        boolean closed = true;
        if (dc instanceof SimpleLifeCycle) {
            SimpleLifeCycle lifeCycle = (SimpleLifeCycle)((Object)dc);
            if (lifeCycle.canPassivate()) {
                lifeCycle.doPassivate(args);
                if (pEvent.isDispose() && dc instanceof Disposable) {
                    ((Disposable)((Object)dc)).dispose(args);
                }
                pEvent.setResult(args);
                if (this.mInActivateDialogs.containsKey(dc)) {
                    OpenDialogEvent openEvent = this.mInActivateDialogs.get(dc);
                    openEvent.setDialogResults(args);
                }
            } else {
                closed = false;
            }
        }
        if (closed) {
            this.mActiveDialogs.remove(dc);
        }
        pEvent.setWasClosed(closed);
        if (this.mCallback != null) {
            this.mCallback.dialogClosed(dc, closed, args);
        }
        pEvent.consume();
    }

    public boolean canPassivate() {
        boolean canPassivate = true;
        int n = this.mActiveDialogs.size();
        for (int i = 0; i < n; ++i) {
            Dc o = this.mActiveDialogs.get(i);
            if (!(o instanceof SimpleLifeCycle)) continue;
            canPassivate = canPassivate && ((SimpleLifeCycle)((Object)o)).canPassivate();
        }
        return canPassivate;
    }

    @Override
    public void dispose(Map<String, ? super Object> pArgs) {
        for (DialogDescription o : this.mKnownDialogs.values()) {
            DialogDescription dialogDescription = o;
            Dc dc = dialogDescription.getDc();
            if (!(dc instanceof Disposable)) continue;
            ((Disposable)((Object)dc)).dispose(pArgs);
        }
        this.mKnownDialogs.clear();
        this.mActiveDialogs.clear();
    }

    public void postAppEvent(Dc pDc, AppEventSupport pAppEventSupport, AppEvent pAppEvent) {
        if (pAppEvent instanceof OpenDialogEvent) {
            OpenDialogEvent openDialogEvent = (OpenDialogEvent)pAppEvent;
            this.openDialog(openDialogEvent, pDc);
        } else if (pAppEvent instanceof CloseDialogEvent) {
            CloseDialogEvent closeDialogEvent = (CloseDialogEvent)pAppEvent;
            this.closeDialog(closeDialogEvent);
        }
        pAppEvent.forward();
        if (!pAppEvent.isConsumed()) {
            AppEventUtil.postAppEvent(pAppEventSupport, pAppEvent);
        }
    }

    public static interface DialogCallback {
        public void dialogOpened(Dc var1, Map<String, Object> var2);

        public void dialogClosed(Dc var1, boolean var2, Map<String, Object> var3);
    }
}

