package net.sf.cuf.xfer;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/**
 * DefaultDispatchTarget is a default implementation for the DispatchTarget interface.
 * In allmost all cases this implementation is suffient.
 */
public class DefaultDispatchTarget implements DispatchTarget
{
    /** our target object */
    private Object mTargetObject;
    /** the method of our target */
    private Method mTargetMethod;


    public void setTarget(final Object pTargetObject, final String pMethodName) throws IllegalArgumentException
    {
        if (pTargetObject==null)
            throw new IllegalArgumentException("pTargetObject must not be null");
        if (pMethodName==null)
            throw new IllegalArgumentException("pMethodName must not be null");
        if (!Modifier.isPublic(pTargetObject.getClass().getModifiers()))
            throw new IllegalArgumentException("pTargetObject must be an object from a public class");

        /*
         * create Method Object, the signature is always
         * void <pMethodname>(Response pResponse)
         */
        Class<?>[] params= {Response.class};
        Method method;
        try
        {
            method= pTargetObject.getClass().getMethod(pMethodName, params);
        }
        catch (NoSuchMethodException e)
        {
            IllegalArgumentException ex = new IllegalArgumentException("No method: "+e.getMessage());
            ex.initCause(e);
            throw ex;
        }

        mTargetObject= pTargetObject;
        mTargetMethod= method;
    }

    public Object getTargetObject()
    {
        return mTargetObject;
    }

    public Method getTargetMethod()
    {
        return mTargetMethod;
    }

    public boolean equals(final Object pObject)
    {
        if (pObject==this)
            return true;
        if (!(pObject instanceof DefaultDispatchTarget))
            return false;

        DefaultDispatchTarget target= (DefaultDispatchTarget) pObject;
        if (target.mTargetObject != mTargetObject)
        {
            return false;
        }

        if (mTargetMethod==null)
        {
            // target.mTargetMethod must be null in this case
            return (target.mTargetMethod==null);
        }

        return target.mTargetMethod.getName().equals(mTargetMethod.getName());
    }

    public int hashCode()
    {
        return (mTargetObject.hashCode() | mTargetMethod.hashCode());
    }

    public String toString()
    {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("[targetObject=");
        sb.append(mTargetObject);
        sb.append(",targetMethod=");
        sb.append(mTargetMethod);
        sb.append(']');
        return sb.toString();
    }

}
