package net.sf.cuf.fw2;

import java.util.Map;

/**
 * The Disposable interface describes a part of a more complex
 * lifecycle, and is used to encapsulate the common life cycle of
 * AppDc, AppPc, DialogDc and DialogPc. <br/>
 * The lifecycle that is described by the Disposable interface is
 * shown below:
 * <code>
 *            dispose()
 *  [passive] --------> [destroyed]
 * </code>
 */
public interface Disposable
{
    /**
     * Called from the peer that coordinates our life cycle to tell us to
     * cleanup all resources.
     * @param pArgs arguments, key is a String, value is any suitable objekt for the key
     */
    void dispose(Map<String, ? super Object> pArgs);
}
