package net.sf.cuf.fw2;

import net.sf.cuf.fw.Dc;
import net.sf.cuf.appevent.AppEventSupport;

/**
 * A DialogDc enhances the basic Dc interface with a more powerful
 * dialog lifecycle and support for AppEvent's.<br/>
 * A DialogDc object is in one of the following five states:
 * <ul>
 * <li>not exist (before new was called)
 * <li>created (new was called and an object exists)
 * <li>initialized (after the call to init())
 * <li>active (after a call to doActivate())
 * <li>passive (after a call to doPassivate())
 * </ul>
 * The life cycle is typical for top level dialogs, that can
 * be activated by the user through some menu/toobar/... mechanism.
 * A dialog should refresh its data completly in the doActivate()
 * call and save (and forget) its data in the doPassivate() call.
 * Depending on the application design, there might be more than one
 * active DialogDc object.
 * Whenever a DialogDc is no longer needed, dispose() can be called
 * when the dialog is in the passive state.
 * <code>
 *                          init()
 * [not exist] -> [created] -----> [initialized]
 *
 *               doActivate()          doPassivate()
 * [initialized] -----------> [active] ------------> [passive]
 *                                     <------------
 *                                     doActivate()
 *            dispose()
 *  [passive] --------> [destroyed]
 * </code>
 * <br/>
 * The parent of a DialogDc is never null and always implements
 * the AppEventSupport interface.
 */
public interface DialogDc extends Dc, AppEventSupport, SimpleLifeCycle, Disposable
{
    /*
     * lifecycle stuff  (the init() method is in Dc, the doActivate(),
     * canPassivate() and doPassivate() methods are inside the SimpleLifeCycle
     * or the Disposable interface.
     */

    /*
     * visual layout stuff
     */

    /**
     * Called from the dialog coordinater in the initialized, active or passive
     * state to get the visual representation for this dialog.
     * @return an object that represents the visual representation of this dialog
     */
    Object getVisualPresentation();
}
