package net.sf.cuf.fw2;

import net.sf.cuf.fw.Dc;
import net.sf.cuf.appevent.AppEvent;
import net.sf.cuf.appevent.AppEventSupport;
import net.sf.cuf.appevent.AppEventUtil;

import java.util.Map;

/**
 * The AbstractDialogPc implements the common stuff (AppEvent handling)
 * of the DialogPc interface.
 * A project specific DialogPc is usally derived from AbstractDialogPc.
 */
public abstract class AbstractDialogPc implements DialogPc
{
    /** The next object in the AppEvent responder chain. */
    protected AppEventSupport mAppEventSupport;

    /**
     * This method is called by the dialog controller peer during
     * the initialisation phase of an application.<br/>
     *
     * @param pDc our peer dialog controller, must implement AppEventSupport
     * @param pArgs variable argument list modeled as a key/value map,
     *              never null.
     */
    public void init(final Dc pDc, final Map<String, ? super Object> pArgs)
    {
        mAppEventSupport= (AppEventSupport)pDc;
    }

    /**
     * Process/Dispatch an AppEvent.
     *
     * @param pAppEvent event that should be routed/processes
     * @throws IllegalArgumentException if pAppEvent is null
     */
    public void postAppEvent(final AppEvent pAppEvent)
    {
        AppEventUtil.postAppEvent(mAppEventSupport, pAppEvent);
    }

    /**
     * Called from the DialogDc peer to cleanup all resources.
     * The base implementation does nothing.
     * @param pArgs arguments, key is a String,
     *              value is any suitable objekt for the key
     */
    public void dispose(final Map<String, ? super Object> pArgs)
    {
    }
}
