package net.sf.cuf.fw;

import java.util.Map;
import java.util.Properties;

/**
 * The Application interface describes the protocol needed to
 * start/stop an application, to maintain the user properties and
 * to get/set the application models.
 */
public interface Application
{
    /**
     * Key for the application object in the argument map passed to
     * the init method of Dc and Pc interfaces.
     */
    public final String APPLICATION_KEY= "Application";

    /**
     * Called to start an application. If the application uses
     * user properties, they should be loaded in this method.
     * @param pArgs the arguments of the static main entry point.
     */
    public void doStart(String[] pArgs);

    /**
     * Called to stop an application. If the application uses
     * user properties, they should be saved in this method.
     * The method shouldn't return.
     */
    public void doStop();

    /**
     * Get a user property of the application, always returns
     * a non-null string if pDefault is not null.
     * @param pKey key of the user property
     * @param pDefault default that should be used if the key is not known
     * @return string describing the user property for pKey or pDefault
     */
    public String getProperty(String pKey, String pDefault);

    /**
     * Set a user property.
     * @param pKey key of the user property
     * @param pValue value of the user property
     */
    public void   setProperty(String pKey, String pValue);

    /**
     * Get all properties of the application.
     * @return properties of the application, never null
     */
    public Properties getProperties();

    /**
     * Returns the models of the applicaton.
     * The map contains String/ValueHolder or String/State or String/any object
     * pairs, so each model has a symbolic name.
     * @return a Map containing all application models
     */
    public Map<String, ? super Object> getAppModel();
}
