package net.sf.cuf.appevent;

/**
 * A UnbindEvent can be used to remove the binding that was
 * established with a BindEvent.
 * @see BindEvent
 */
public class UnbindEvent extends AppEvent
{
    /** trigger class */
    private Class<? extends AppEvent> mAppEventToUnbindFrom;

    /**
     * The constructor creates a UnbindEvent with the handed values.
     *
     * @param pSource               sender object, will receive the callback
     * @param pAppEventToUnbindFrom trigger class, must be a subclass of AppEvent
     * @throws IllegalArgumentException if one of the arguments is null
     */
    public UnbindEvent(final Object pSource, final Class<? extends AppEvent> pAppEventToUnbindFrom)
    {
        super(pSource);
        if (pSource==null)
            throw new IllegalArgumentException("pSource must not be null");
        if (pAppEventToUnbindFrom==null)
            throw new IllegalArgumentException("pAppEventToUnbindFrom must not be null");
        if (!AppEvent.class.isAssignableFrom(pAppEventToUnbindFrom))
            throw new IllegalArgumentException(pAppEventToUnbindFrom.getName() + " is not derived from AppEvent");

        mAppEventToUnbindFrom= pAppEventToUnbindFrom;
    }

    /**
     * Returns the target for the binding.
     *
     * @return target object
     */
    public Object getTarget()
    {
        return source;
    }

    /**
     * Returns the AppEvent derived class that the target is interested in.
     *
     * @return trigger class
     */
    public Class<? extends AppEvent> getTriggerClass()
    {
        return mAppEventToUnbindFrom;
    }
}
