package net.sf.cuf.appevent;

/**
 * This interface is a marker for all objects that want to
 * form a "chain of responsabilty" to dispatch events to
 * receivers.
 */
public interface AppEventSupport
{
    /**
     * Process/Dispatch an AppEvent.
     * Each processing step should call forward() on the event
     * beforing doing any further dispatching/processing and
     * check after the forward() call if the event is not
     * allready consumed.
     *
     * @param pAppEvent event that should be routed/processes
     * @throws IllegalArgumentException if pAppEvent is null
     */
    public void postAppEvent(AppEvent pAppEvent);
}
