/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvviewfx.about;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.SequentialTransitionBuilder;
import javafx.animation.Transition;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import net.sf.cuf.csvviewfx.Version;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw.Pc;

public class AboutPc
implements Pc {
    private static final Duration FADE_DURATION = Duration.seconds((double)3.0);
    @FXML
    private Image mAppIcon;
    @FXML
    private Image mAboutImage;
    @FXML
    private Image mAuthorImage;
    @FXML
    private Label mAboutLabel;
    @FXML
    private ImageView mAboutLogo;
    @FXML
    public StackPane mRootContainer;
    @FXML
    private Label mVersion;
    @FXML
    private Label mJdk;
    private Stage mStage;
    private Stage mMainStage;
    private List<Transition> mTransitions = new ArrayList<Transition>();

    public void init(Dc pDc, Map<String, ? super Object> pArgs) {
        this.mMainStage = (Stage)pArgs.get("mainStage");
        String versionText = this.mVersion.getText() + ", Version " + Version.VERSION + " (" + Version.DATE + " )";
        this.mVersion.setText(versionText);
        String jdkText = "Java VM from " + System.getProperty("java.vendor") + ", Version " + System.getProperty("java.version");
        this.mJdk.setText(jdkText);
        double maxWidth = Math.max(this.mAuthorImage.getWidth(), this.mAboutImage.getWidth());
        double maxHeight = Math.max(this.mAuthorImage.getHeight(), this.mAboutImage.getHeight());
        this.mAboutLabel.setMinHeight(maxHeight);
        this.mAboutLabel.setMinWidth(maxWidth);
        Transition transitionForward = this.createTransition(this.mAboutLogo, this.mAuthorImage);
        Transition transitionBackward = this.createTransition(this.mAboutLogo, this.mAboutImage);
        this.mTransitions.add(transitionBackward);
        this.mTransitions.add(transitionBackward);
        this.mAboutLabel.setOnMouseClicked(pMouseEvent -> {
            if (this.mAboutLogo.getImage().equals(this.mAboutImage)) {
                transitionForward.play();
            } else {
                transitionBackward.play();
            }
        });
    }

    private Transition createTransition(ImageView pImageView, Image pNewImage) {
        FadeTransition fadeOutTransition = new FadeTransition(FADE_DURATION, (Node)pImageView);
        fadeOutTransition.setFromValue(1.0);
        fadeOutTransition.setToValue(0.0);
        fadeOutTransition.setOnFinished(pActionEvent -> pImageView.setImage(pNewImage));
        FadeTransition fadeInTransition = new FadeTransition(FADE_DURATION, (Node)pImageView);
        fadeInTransition.setFromValue(0.0);
        fadeInTransition.setToValue(1.0);
        return SequentialTransitionBuilder.create().children(new Animation[]{fadeOutTransition, fadeInTransition}).build();
    }

    void show() {
        this.mStage = new Stage();
        this.mStage.initOwner((Window)this.mMainStage);
        Scene scene = new Scene((Parent)this.mRootContainer);
        this.mStage.setScene(scene);
        this.mStage.setTitle("\u00dcber");
        this.mStage.initModality(Modality.WINDOW_MODAL);
        this.mStage.setOnCloseRequest(pWindowEvent -> {
            pWindowEvent.consume();
            this.ok();
        });
        this.mStage.getIcons().add((Object)this.mAppIcon);
        this.mAboutLogo.setImage(this.mAboutImage);
        this.mStage.showAndWait();
        this.mStage = null;
    }

    public void ok() {
        this.mStage.hide();
        for (Transition transition : this.mTransitions) {
            transition.stop();
        }
    }
}

