/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvviewfx.option;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.image.Image;
import javafx.scene.layout.StackPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.sf.cuf.appevent.AppEvent;
import net.sf.cuf.appevent.AppEventSupport;
import net.sf.cuf.appevent.AppEventUtil;
import net.sf.cuf.csvviewfx.AppData;
import net.sf.cuf.csvviewfx.DataSourceChanged;
import net.sf.cuf.csvviewfx.option.OptionDc;
import net.sf.cuf.fw.Application;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw.Pc;

public class OptionPc
implements Pc,
AppEventSupport {
    @FXML
    private Image mAppIcon;
    @FXML
    public StackPane mRootContainer;
    @FXML
    private TextField mFileText;
    @FXML
    private RadioButton mTree;
    @FXML
    private TextField mTreeText;
    @FXML
    private CheckBox mFirstRow;
    @FXML
    private TextField mCSVSeparator;
    @FXML
    private ComboBox<String> mEncoding;
    @FXML
    private RadioButton mCell;
    @FXML
    private RadioButton mRow;
    @FXML
    public Button mDefault;
    @FXML
    public Button mCancel;
    @FXML
    public Button mOK;
    private Stage mMainStage;
    private Application mApplication;
    private Stage mStage;
    private OptionDc mDc;
    private static final List<String> INPUT_MAPPING = Arrays.asList("file", "tree");

    public void init(Dc pDc, Map<String, ? super Object> pArgs) {
        this.mApplication = (Application)pArgs.get("Application");
        this.mDc = (OptionDc)pDc;
        this.mMainStage = (Stage)pArgs.get("mainStage");
    }

    public void postAppEvent(AppEvent pAppEvent) {
        AppEventUtil.postAppEvent((AppEventSupport)this.mDc, (AppEvent)pAppEvent);
    }

    void show() {
        this.mStage = new Stage();
        this.mStage.initOwner((Window)this.mMainStage);
        Scene scene = new Scene((Parent)this.mRootContainer);
        this.mStage.setScene(scene);
        this.mStage.setTitle("Optionen");
        this.mStage.initModality(Modality.WINDOW_MODAL);
        this.mStage.setOnCloseRequest(pWindowEvent -> {
            pWindowEvent.consume();
            this.cancel();
        });
        this.mStage.getIcons().add((Object)this.mAppIcon);
        this.initData();
        this.mStage.showAndWait();
        this.mStage = null;
    }

    private void initData() {
        int index = INPUT_MAPPING.indexOf(this.mApplication.getProperty("InputSelection", "file"));
        if (index < 0) {
            index = INPUT_MAPPING.indexOf("file");
        }
        ((Toggle)this.mTree.getToggleGroup().getToggles().get(index)).setSelected(true);
        this.mFileText.setText(this.mApplication.getProperty("fileName", "../cuf-csvview/src/test/resources/ca-500.csv"));
        this.mTreeText.setText(this.mApplication.getProperty("default.treeName", AppData.TREE_NAME_DEFAULT));
        boolean firstRowIsHeader = Boolean.valueOf(this.mApplication.getProperty("setFirstRowIsHeader", "true"));
        this.mFirstRow.setSelected(firstRowIsHeader);
        String seperator = this.mApplication.getProperty("csvSeparator", ",");
        this.mCSVSeparator.setText(seperator);
        String encoding = this.mApplication.getProperty("encoding", "Cp1252");
        this.mEncoding.getSelectionModel().select((Object)encoding);
        BooleanProperty copyRow = (BooleanProperty)this.mApplication.getAppModel().get("CopyWholeRow");
        this.mRow.setSelected(copyRow.getValue().booleanValue());
        this.mCell.setSelected(copyRow.getValue() == false);
    }

    public void searchFile() {
        Object file2;
        FileChooser fileChooser = new FileChooser();
        try {
            file2 = this.mFileText.getText();
            File initialDir = new File((String)file2).getCanonicalFile().getParentFile();
            if (initialDir.isDirectory()) {
                fileChooser.setInitialDirectory(initialDir);
            }
        }
        catch (IOException file2) {
            // empty catch block
        }
        fileChooser.getExtensionFilters().add((Object)AppData.CSV_EXTENSIONS);
        file2 = fileChooser.showOpenDialog(this.mStage.getScene().getWindow());
        if (file2 != null && ((File)file2).isFile()) {
            this.mFileText.setText(((File)file2).getPath());
        }
    }

    public void searchDir() {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        try {
            String dir = this.mTreeText.getText();
            File initialDir = new File(dir).getCanonicalFile();
            if (initialDir.isDirectory()) {
                directoryChooser.setInitialDirectory(initialDir);
            }
        }
        catch (IOException dir) {
            // empty catch block
        }
        File file = directoryChooser.showDialog(this.mStage.getScene().getWindow());
        if (file != null && file.isDirectory()) {
            this.mFileText.setText(file.getPath());
        }
    }

    public void ok() {
        String newEncoding;
        String oldEncoding;
        String newSeperator;
        String oldSeperator;
        boolean newFirstRowIsHeader;
        boolean oldFirstRowIsHeader;
        int newIndex;
        boolean sourceChanged = false;
        int oldIndex = INPUT_MAPPING.indexOf(this.mApplication.getProperty("InputSelection", "file"));
        if (oldIndex != (newIndex = this.mTree.getToggleGroup().getToggles().indexOf((Object)this.mTree.getToggleGroup().getSelectedToggle()))) {
            this.mApplication.setProperty("InputSelection", INPUT_MAPPING.get(newIndex));
            sourceChanged = true;
        }
        String newFileText = this.mFileText.getText();
        String oldFileText = this.mApplication.getProperty("fileName", "../cuf-csvview/src/test/resources/ca-500.csv");
        if (!oldFileText.equals(newFileText)) {
            this.mApplication.setProperty("fileopen.dir", new File(newFileText).getParent());
            this.mApplication.setProperty("fileName", newFileText);
            sourceChanged = sourceChanged || newIndex == INPUT_MAPPING.indexOf("file");
        }
        String newTreeText = this.mTreeText.getText();
        String oldTreeText = this.mApplication.getProperty("default.treeName", AppData.TREE_NAME_DEFAULT);
        if (!oldTreeText.equals(newTreeText)) {
            this.mApplication.setProperty("fileopen.dir", newTreeText);
            this.mApplication.setProperty("default.treeName", newTreeText);
            boolean bl = sourceChanged = sourceChanged || newIndex == INPUT_MAPPING.indexOf("tree");
        }
        if ((oldFirstRowIsHeader = Boolean.valueOf(this.mApplication.getProperty("setFirstRowIsHeader", "true")).booleanValue()) != (newFirstRowIsHeader = this.mFirstRow.isSelected())) {
            this.mApplication.setProperty("setFirstRowIsHeader", Boolean.toString(newFirstRowIsHeader));
            boolean bl = sourceChanged = sourceChanged || newIndex == INPUT_MAPPING.indexOf("file");
        }
        if (!(oldSeperator = this.mApplication.getProperty("csvSeparator", ",")).equals(newSeperator = this.mCSVSeparator.getText())) {
            this.mApplication.setProperty("csvSeparator", newSeperator);
            boolean bl = sourceChanged = sourceChanged || newIndex == INPUT_MAPPING.indexOf("file");
        }
        if (!(oldEncoding = this.mApplication.getProperty("encoding", "Cp1252")).equals(newEncoding = (String)this.mEncoding.getSelectionModel().getSelectedItem())) {
            this.mApplication.setProperty("encoding", newEncoding);
            sourceChanged = sourceChanged || newIndex == INPUT_MAPPING.indexOf("file");
        }
        BooleanProperty copyRow = (BooleanProperty)this.mApplication.getAppModel().get("CopyWholeRow");
        if (this.mRow.isSelected() != copyRow.getValue().booleanValue()) {
            copyRow.setValue(Boolean.valueOf(this.mRow.isSelected()));
        }
        if (sourceChanged) {
            this.postAppEvent(new DataSourceChanged(this));
        }
        this.mStage.hide();
    }

    public void cancel() {
        this.mStage.hide();
    }

    public void defaults() {
        int index = INPUT_MAPPING.indexOf("file");
        ((Toggle)this.mTree.getToggleGroup().getToggles().get(index)).setSelected(true);
        this.mFileText.setText("../cuf-csvview/src/test/resources/ca-500.csv");
        this.mTreeText.setText(AppData.TREE_NAME_DEFAULT);
        this.mFirstRow.setSelected(Boolean.valueOf("true").booleanValue());
        this.mCSVSeparator.setText(",");
        this.mEncoding.getSelectionModel().select((Object)"Cp1252");
        this.mRow.setSelected(Boolean.valueOf("false").booleanValue());
        this.mCell.setSelected(Boolean.valueOf("false") == false);
    }
}

