/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvviewfx.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import net.sf.cuf.csvviewfx.data.FilteredObservableList;

public abstract class AbstractFilteredObservableList
implements FilteredObservableList {
    protected List<Map<String, String>> mAllRows;
    protected Map<Integer, String> mRowHeaders;
    protected ObservableList<Map<String, String>> mFilteredRows;

    @Override
    public int getAllRowsCount() {
        return this.mAllRows.size();
    }

    @Override
    public int getColumnCount() {
        return this.mRowHeaders.size();
    }

    @Override
    public String getColumnName(int pColumnIndex) {
        return this.mRowHeaders.get(pColumnIndex);
    }

    @Override
    public boolean filter(String pFilterExpression) {
        Pattern filter;
        if (pFilterExpression == null) {
            return false;
        }
        try {
            filter = Pattern.compile(pFilterExpression, 2);
        }
        catch (PatternSyntaxException ignored) {
            return false;
        }
        Matcher match = filter.matcher("");
        ArrayList<Map<String, String>> filteredRows = new ArrayList<Map<String, String>>(this.mAllRows.size());
        block2: for (Map<String, String> row : this.mAllRows) {
            for (String field : row.values()) {
                match.reset(field);
                if (!match.find()) continue;
                filteredRows.add(row);
                continue block2;
            }
        }
        this.mFilteredRows.clear();
        this.mFilteredRows.addAll(filteredRows);
        return true;
    }

    @Override
    public void filterReset() {
        this.mFilteredRows.clear();
        this.mFilteredRows.addAll(this.mAllRows);
    }

    public void addListener(ListChangeListener<? super Map<String, String>> pListChangeListener) {
        this.mFilteredRows.addListener(pListChangeListener);
    }

    public void removeListener(ListChangeListener<? super Map<String, String>> pListChangeListener) {
        this.mFilteredRows.removeListener(pListChangeListener);
    }

    public boolean addAll(Map<String, String> ... pMaps) {
        return this.mFilteredRows.addAll((Object[])pMaps);
    }

    public boolean setAll(Map<String, String> ... pMaps) {
        return this.mFilteredRows.setAll((Object[])pMaps);
    }

    public boolean setAll(Collection<? extends Map<String, String>> pMaps) {
        return this.mFilteredRows.setAll(pMaps);
    }

    public boolean removeAll(Map<String, String> ... pMaps) {
        return this.mFilteredRows.removeAll((Object[])pMaps);
    }

    public boolean retainAll(Map<String, String> ... pMaps) {
        return this.mFilteredRows.retainAll((Object[])pMaps);
    }

    public void remove(int pFrom, int pTo) {
        this.mFilteredRows.remove(pFrom, pTo);
    }

    public int size() {
        return this.mFilteredRows.size();
    }

    public boolean isEmpty() {
        return this.mFilteredRows.isEmpty();
    }

    public boolean contains(Object pObject) {
        return this.mFilteredRows.contains(pObject);
    }

    public Iterator<Map<String, String>> iterator() {
        return this.mFilteredRows.iterator();
    }

    public Object[] toArray() {
        return this.mFilteredRows.toArray();
    }

    public <T> T[] toArray(T[] pArray) {
        return this.mFilteredRows.toArray((Object[])pArray);
    }

    public boolean add(Map<String, String> pElement) {
        return this.mFilteredRows.add(pElement);
    }

    public boolean remove(Object pElement) {
        return this.mFilteredRows.remove(pElement);
    }

    public boolean containsAll(Collection<?> pElements) {
        return this.mFilteredRows.containsAll(pElements);
    }

    public boolean addAll(Collection<? extends Map<String, String>> pElements) {
        return this.mFilteredRows.addAll(pElements);
    }

    public boolean addAll(int index, Collection<? extends Map<String, String>> pElements) {
        return this.mFilteredRows.addAll(index, pElements);
    }

    public boolean removeAll(Collection<?> pElements) {
        return this.mFilteredRows.removeAll(pElements);
    }

    public boolean retainAll(Collection<?> pElements) {
        return this.mFilteredRows.retainAll(pElements);
    }

    public void clear() {
        this.mFilteredRows.clear();
    }

    public boolean equals(Object pOther) {
        return this.mFilteredRows.equals(pOther);
    }

    public int hashCode() {
        return this.mFilteredRows.hashCode();
    }

    public Map<String, String> get(int pIndex) {
        return (Map)this.mFilteredRows.get(pIndex);
    }

    public Map<String, String> set(int pIndex, Map<String, String> pElement) {
        return (Map)this.mFilteredRows.set(pIndex, pElement);
    }

    public void add(int pIndex, Map<String, String> pElement) {
        this.mFilteredRows.add(pIndex, pElement);
    }

    public Map<String, String> remove(int pIndex) {
        return (Map)this.mFilteredRows.remove(pIndex);
    }

    public int indexOf(Object pElement) {
        return this.mFilteredRows.indexOf(pElement);
    }

    public int lastIndexOf(Object pElement) {
        return this.mFilteredRows.lastIndexOf(pElement);
    }

    public ListIterator<Map<String, String>> listIterator() {
        return this.mFilteredRows.listIterator();
    }

    public ListIterator<Map<String, String>> listIterator(int pIndex) {
        return this.mFilteredRows.listIterator(pIndex);
    }

    public List<Map<String, String>> subList(int pFromIndex, int pToindex) {
        return this.mFilteredRows.subList(pFromIndex, pToindex);
    }

    public void addListener(InvalidationListener pInvalidationListener) {
        this.mFilteredRows.addListener(pInvalidationListener);
    }

    public void removeListener(InvalidationListener pInvalidationListener) {
        this.mFilteredRows.removeListener(pInvalidationListener);
    }
}

