/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvviewfx.data;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javafx.collections.FXCollections;
import net.sf.cuf.csvviewfx.data.AbstractFilteredObservableList;

public class TreeFilteredObservableList
extends AbstractFilteredObservableList {
    private static final String[] HEADER = new String[]{"path", "name", "size", "last modified"};

    public TreeFilteredObservableList(File pRootNode) {
        if (pRootNode == null) {
            throw new IllegalArgumentException("root file node must not be null");
        }
        this.mRowHeaders = new HashMap(HEADER.length);
        int n = HEADER.length;
        for (int i = 0; i < n; ++i) {
            this.mRowHeaders.put(i, HEADER[i]);
        }
        this.mAllRows = new ArrayList();
        this.traverseTree(pRootNode);
        this.mFilteredRows = FXCollections.observableArrayList((Collection)this.mAllRows);
    }

    private void traverseTree(File pCurrentNode) {
        File[] children;
        if (!pCurrentNode.canRead() || !pCurrentNode.exists()) {
            return;
        }
        HashMap<String, String> row = new HashMap<String, String>(HEADER.length);
        row.put(HEADER[0], pCurrentNode.getPath());
        row.put(HEADER[1], pCurrentNode.getName());
        row.put(HEADER[2], Long.toString(pCurrentNode.length()));
        row.put(HEADER[3], new Date(pCurrentNode.lastModified()).toString());
        this.mAllRows.add(row);
        if (pCurrentNode.isDirectory() && (children = pCurrentNode.listFiles()) != null) {
            for (File child : children) {
                this.traverseTree(child);
            }
        }
    }
}

