/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvviewfx.main;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.sf.cuf.appevent.AppEvent;
import net.sf.cuf.appevent.AppEventManager;
import net.sf.cuf.appevent.AppEventSupport;
import net.sf.cuf.appevent.AppEventUtil;
import net.sf.cuf.appevent.BindEvent;
import net.sf.cuf.csvviewfx.AppData;
import net.sf.cuf.csvviewfx.DataSourceChanged;
import net.sf.cuf.csvviewfx.about.AboutDc;
import net.sf.cuf.csvviewfx.data.CsvFileredObservableList;
import net.sf.cuf.csvviewfx.data.FilteredObservableList;
import net.sf.cuf.csvviewfx.main.LoadFileRequest;
import net.sf.cuf.csvviewfx.main.LoadTreeRequest;
import net.sf.cuf.csvviewfx.main.MainPc;
import net.sf.cuf.csvviewfx.option.OptionDc;
import net.sf.cuf.fw.Application;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.xfer.AbstractRequest;
import net.sf.cuf.xfer.Dispatch;
import net.sf.cuf.xfer.JavaFXDispatcher;
import net.sf.cuf.xfer.Request;
import net.sf.cuf.xfer.Response;

public class MainDc
implements Dc,
AppEventSupport {
    static final String TABLE_ARG = "tableModel";
    private AppEventManager mAppEventManger = new AppEventManager();
    private Dispatch mDispatcher = new JavaFXDispatcher();
    private MainPc mPc;
    private AboutDc mAboutDc;
    private OptionDc mOptionDc;
    private Application mApplication;

    public MainDc(MainPc pPc) {
        this.mPc = pPc;
    }

    public void init(Dc pParent, Map<String, ? super Object> pArgs) {
        this.mApplication = (Application)pArgs.get("Application");
        BindEvent bindEvent = new BindEvent((Object)this, this::dataSourceChanged, DataSourceChanged.class);
        this.postAppEvent((AppEvent)bindEvent);
        this.mAboutDc = new AboutDc();
        this.mAboutDc.init(this, pArgs);
        this.mOptionDc = new OptionDc();
        this.mOptionDc.init(this, pArgs);
        Request<FilteredObservableList> loadDataRequest = this.getCurrentRequest();
        Response response = this.mDispatcher.syncExecute(loadDataRequest);
        FilteredObservableList firstData = response.isValid() ? (FilteredObservableList)response.getResult() : new CsvFileredObservableList();
        HashMap<String, ? super Object> args = new HashMap<String, Object>(pArgs);
        args.put(TABLE_ARG, firstData);
        this.mPc.init(this, args);
    }

    public void postAppEvent(AppEvent pAppEvent) {
        AppEventUtil.postAppEvent((AppEventSupport)this.mAppEventManger, (AppEvent)pAppEvent);
    }

    private Request<FilteredObservableList> getCurrentRequest() {
        AbstractRequest request;
        String inputSelection = this.mApplication.getProperty("InputSelection", "file");
        if ("file".equals(inputSelection)) {
            File file = new File(this.mApplication.getProperty("fileName", "../cuf-csvview/src/test/resources/ca-500.csv"));
            boolean firstRowIsHeader = Boolean.valueOf(this.mApplication.getProperty("setFirstRowIsHeader", "true"));
            String seperator = this.mApplication.getProperty("csvSeparator", ",");
            String encoding = this.mApplication.getProperty("encoding", "Cp1252");
            request = new LoadFileRequest(file, firstRowIsHeader, seperator, encoding);
        } else {
            File tree = new File(this.mApplication.getProperty("default.treeName", AppData.TREE_NAME_DEFAULT));
            request = new LoadTreeRequest<FilteredObservableList>(tree);
        }
        return request;
    }

    public void dataSourceChanged(DataSourceChanged pDataSourceChanged) {
        Request<FilteredObservableList> loadDataRequest = this.getCurrentRequest();
        loadDataRequest.setDispatchTarget(this::loadResponse);
        this.mDispatcher.asyncDispatchInEDT(loadDataRequest);
    }

    void openFile(File pFile) {
        boolean firstRowIsHeader = Boolean.valueOf(this.mApplication.getProperty("setFirstRowIsHeader", "true"));
        String seperator = this.mApplication.getProperty("csvSeparator", ",");
        String encoding = this.mApplication.getProperty("encoding", "Cp1252");
        LoadFileRequest request = new LoadFileRequest(pFile, firstRowIsHeader, seperator, encoding);
        request.setDispatchTarget(this::loadResponse);
        this.mDispatcher.asyncDispatchInEDT(request);
    }

    public void openTree(File pDirectory) {
        LoadTreeRequest request = new LoadTreeRequest(pDirectory);
        request.setDispatchTarget(this::loadResponse);
        this.mDispatcher.asyncDispatchInEDT(request);
    }

    public void loadResponse(Response<FilteredObservableList> pResponse) {
        if (pResponse.isValid()) {
            FilteredObservableList newModel = (FilteredObservableList)pResponse.getResult();
            this.mPc.setModel(newModel);
        } else {
            this.mPc.showLoadError(pResponse);
        }
    }

    void showAbout() {
        this.mAboutDc.show();
    }

    void showOptions() {
        this.mOptionDc.show();
    }
}

