/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvviewfx.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sf.cuf.csvviewfx.data.CsvFileredObservableList;
import net.sf.cuf.csvviewfx.main.AbstractLoadRequest;
import net.sf.cuf.csvviewfx.main.LoadDataRequest;
import net.sf.cuf.xfer.DefaultResponse;
import net.sf.cuf.xfer.Response;

public class LoadFileRequest<T>
extends AbstractLoadRequest<T>
implements LoadDataRequest<T> {
    private File mFile;

    public LoadFileRequest(File pFile, boolean pFirstRowIsHeader, String pCSVSeparator, String pEncoding) {
        super(pCSVSeparator, pEncoding, pFirstRowIsHeader);
        if (pFile == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        this.mFile = pFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response<T> execute() {
        DefaultResponse response = new DefaultResponse();
        FileInputStream input = null;
        try {
            input = new FileInputStream(this.mFile);
            CsvFileredObservableList model = new CsvFileredObservableList(input, this.mFirstRowIsHeader, this.mCSVSeparator, this.mEncoding);
            response.setResult((Object)model);
        }
        catch (Exception e) {
            response.setError((Object)e);
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException iOException) {}
            }
        }
        return response;
    }
}

