/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvviewfx.util;

import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;

public class TableCopyAction
implements EventHandler<KeyEvent> {
    private static final KeyCombination COPY_ACTION = KeyCombination.valueOf((String)"Shortcut+C");
    private BooleanProperty mCopyRow;

    public TableCopyAction(BooleanProperty pCopyRow) {
        if (pCopyRow == null) {
            throw new IllegalArgumentException("copy row property must not be null");
        }
        this.mCopyRow = pCopyRow;
    }

    public void handle(KeyEvent pKeyEvent) {
        if (!COPY_ACTION.match(pKeyEvent)) {
            return;
        }
        Object source = pKeyEvent.getSource();
        if (!(source instanceof TableView)) {
            return;
        }
        TableView tableView = (TableView)source;
        if (tableView.getSelectionModel().getSelectedIndex() < 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (this.mCopyRow.getValue().booleanValue()) {
            ObservableList selectedRows = tableView.getSelectionModel().getSelectedIndices();
            int rowCount = selectedRows.size();
            int columnCount = tableView.getColumns().size();
            int rows = 0;
            int columns = 0;
            for (Integer selectedRow : selectedRows) {
                for (TableColumn tableColumn : tableView.getColumns()) {
                    Object cellData = tableColumn.getCellData(selectedRow.intValue());
                    if (cellData != null) {
                        sb.append(cellData);
                    }
                    if (++columns >= columnCount) continue;
                    sb.append('\t');
                }
                if (++rows >= rowCount) continue;
                sb.append('\n');
            }
        } else if (!tableView.getSelectionModel().getSelectedCells().isEmpty()) {
            TablePosition pos = (TablePosition)tableView.getSelectionModel().getSelectedCells().get(0);
            int r = pos.getRow();
            int c = pos.getColumn();
            Object cellData = ((TableColumn)tableView.getColumns().get(c)).getCellData(r);
            if (cellData != null) {
                sb.append(cellData);
            }
        }
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putString(sb.toString());
        clipboard.setContent((Map)content);
        pKeyEvent.consume();
    }
}

