/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvviewfx.main;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.MapValueFactory;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import net.sf.cuf.csvviewfx.AppData;
import net.sf.cuf.csvviewfx.data.FilteredObservableList;
import net.sf.cuf.csvviewfx.main.MainDc;
import net.sf.cuf.csvviewfx.util.TableCopyAction;
import net.sf.cuf.fw.Application;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw.Pc;
import net.sf.cuf.xfer.Response;

public class MainPc
implements Pc {
    @FXML
    private Image mAppIcon;
    @FXML
    private CheckBox mAutoFilter;
    @FXML
    private Label mStatusText;
    @FXML
    private TextField mFilter;
    @FXML
    private TableView mCsvTable;
    private Scene mScene;
    @FXML
    public BorderPane mRootContainer;
    private Application mApplication;
    private MainDc mDc;
    private String mOldFilterText;
    private Tooltip mOldTooltip;
    private String mOldBackground;
    private FilteredObservableList mModel;

    public void init(Dc pDc, Map<String, ? super Object> pArgs) {
        this.mApplication = (Application)pArgs.get("Application");
        this.mDc = (MainDc)pDc;
        this.setModel((FilteredObservableList)pArgs.get("tableModel"));
        Platform.setImplicitExit((boolean)false);
        Stage stage = (Stage)pArgs.get("mainStage");
        stage.setTitle("CsvView: die CSV CUF Testanwendung");
        this.mScene = new Scene((Parent)this.mRootContainer);
        stage.setScene(this.mScene);
        stage.setOnCloseRequest(pWindowEvent -> {
            pWindowEvent.consume();
            this.quit();
        });
        stage.getIcons().add((Object)this.mAppIcon);
        double x = Double.parseDouble("40");
        double y = Double.parseDouble("30");
        double width = Double.parseDouble("800");
        double height = Double.parseDouble("800");
        try {
            x = Double.parseDouble(this.mApplication.getProperty("windowsize.x", "40"));
            y = Double.parseDouble(this.mApplication.getProperty("windowsize.y", "30"));
            width = Double.parseDouble(this.mApplication.getProperty("windowsize.width", "800"));
            height = Double.parseDouble(this.mApplication.getProperty("windowsize.height", "450"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        stage.setX(x);
        stage.setY(y);
        stage.setWidth(width);
        stage.setHeight(height);
        boolean doAutofilter = Boolean.valueOf(this.mApplication.getProperty("autofilter", "true"));
        this.mAutoFilter.setSelected(doAutofilter);
        String filterText = this.mApplication.getProperty("filter", null);
        if (filterText != null) {
            this.mFilter.setText(filterText);
            this.mFilter.selectAll();
            this.mFilter.requestFocus();
            this.doFilter(filterText);
        }
        this.mOldFilterText = null;
        this.mOldTooltip = this.mFilter.getTooltip();
        this.mOldBackground = this.mFilter.getStyle();
        this.mFilter.textProperty().addListener((pObservableValue, pOldValue, pNewValue) -> {
            if (this.mAutoFilter.isSelected() && !pNewValue.equals(this.mOldFilterText)) {
                this.doFilter((String)pNewValue);
            }
        });
        this.mCsvTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        BooleanProperty copyRow = (BooleanProperty)this.mApplication.getAppModel().get("CopyWholeRow");
        this.mCsvTable.setOnKeyReleased((EventHandler)new TableCopyAction(copyRow));
        this.mCsvTable.getSelectionModel().getSelectedIndices().addListener(pChange -> this.updateStatusLabel());
        this.updateStatusLabel();
        stage.show();
    }

    private void doFilter(String pFilterText) {
        if (pFilterText.isEmpty()) {
            this.mModel.filterReset();
        } else {
            boolean filterOK = this.mModel.filter(pFilterText);
            if (filterOK) {
                this.mFilter.setTooltip(this.mOldTooltip);
                this.mFilter.setStyle(this.mOldBackground);
            } else {
                this.mFilter.setStyle("-fx-background-color: cyan;");
                this.mFilter.setTooltip(new Tooltip("Eingabe ist keine g\u00fcltiger regul\u00e4rer Ausdruck"));
            }
        }
        this.updateStatusLabel();
        this.mOldFilterText = pFilterText;
    }

    private void updateStatusLabel() {
        int allRows = this.mModel.getAllRowsCount();
        int rows = this.mModel.size();
        int selected = this.mCsvTable.getSelectionModel().getSelectedIndices().size();
        this.mStatusText.setText(allRows + " Zeilen, davon " + rows + " gefiltered und " + selected + " selektiert");
    }

    public void openFile() {
        FileChooser fileChooser = new FileChooser();
        try {
            String dir = this.mApplication.getProperty("fileopen.dir", ".");
            File initialDir = new File(dir).getCanonicalFile();
            if (initialDir.isDirectory()) {
                fileChooser.setInitialDirectory(initialDir);
            }
        }
        catch (IOException dir) {
            // empty catch block
        }
        fileChooser.getExtensionFilters().add((Object)AppData.CSV_EXTENSIONS);
        File file = fileChooser.showOpenDialog(this.mScene.getWindow());
        if (file != null && file.isFile()) {
            this.mDc.openFile(file);
            this.mApplication.setProperty("fileopen.dir", file.getParent());
            this.mApplication.setProperty("fileName", file.getAbsolutePath());
            this.mApplication.setProperty("InputSelection", "file");
        }
    }

    public void openTree() {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        try {
            String dir = this.mApplication.getProperty("fileopen.dir", ".");
            File initialDir = new File(dir).getCanonicalFile();
            if (initialDir.isDirectory()) {
                directoryChooser.setInitialDirectory(initialDir);
            }
        }
        catch (IOException dir) {
            // empty catch block
        }
        File file = directoryChooser.showDialog(this.mScene.getWindow());
        if (file != null && file.isDirectory()) {
            this.mDc.openTree(file);
            this.mApplication.setProperty("fileopen.dir", file.getAbsolutePath());
            this.mApplication.setProperty("default.treeName", file.getAbsolutePath());
            this.mApplication.setProperty("InputSelection", "tree");
        }
    }

    public void quit() {
        Window window = this.mScene.getWindow();
        double width = window.getWidth();
        double height = window.getHeight();
        double x = window.getX();
        double y = window.getY();
        this.mApplication.setProperty("windowsize.x", Double.toString(x));
        this.mApplication.setProperty("windowsize.y", Double.toString(y));
        this.mApplication.setProperty("windowsize.width", Double.toString(width));
        this.mApplication.setProperty("windowsize.height", Double.toString(height));
        this.mApplication.setProperty("autofilter", Boolean.toString(this.mAutoFilter.isSelected()));
        this.mApplication.setProperty("filter", this.mFilter.getText());
        Platform.exit();
    }

    public void showOptions() {
        this.mDc.showOptions();
    }

    public void showAbout() {
        this.mDc.showAbout();
    }

    public void autoFilterChanged() {
        if (this.mAutoFilter.isSelected()) {
            this.doFilter(this.mFilter.getText());
        }
    }

    public void search() {
        this.doFilter(this.mFilter.getText());
    }

    public void setModel(FilteredObservableList pModel) {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>(pModel.getColumnCount());
        int n = pModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String columnName = pModel.getColumnName(i);
            TableColumn tableColumn = new TableColumn(columnName);
            tableColumn.setCellValueFactory((Callback)new MapValueFactory((Object)columnName));
            columns.add(tableColumn);
        }
        this.mCsvTable.getColumns().clear();
        this.mCsvTable.getColumns().addAll(columns);
        this.mCsvTable.setItems((ObservableList)pModel);
        this.mModel = pModel;
        if (this.mAutoFilter.isSelected()) {
            this.doFilter(this.mFilter.getText());
        }
    }

    public void showLoadError(Response<?> pResponse) {
        StringBuilder sb = new StringBuilder();
        sb.append("BAD NEWS!\n");
        sb.append("W\u00e4hrend des Ladens ging etwas schief:\n");
        if (pResponse.getError() == null) {
            sb.append("Aber wir wissen nicht was :-(");
        } else {
            sb.append(pResponse.getError());
        }
        System.out.println("showLoadError: " + sb);
    }
}

