package net.sf.cuf.csvviewfx.about;

import net.sf.cuf.fw.Dc;
import javafx.fxml.FXMLLoader;

import java.io.IOException;
import java.util.Map;

/**
 * Dialog controller for the about dialog.
 */
public class AboutDc implements Dc
{
    /** our presentation controller, never null after init was called */
    private AboutPc mPc;

    /**
     * Create a new dialog controller, the presentation controller is lazy
     * created in our {@link #init} method.
     */
    public AboutDc()
    {
    }

    /** {@inheritDoc} */
    @Override
    public void init(final Dc pParent, final Map<String, ? super Object> pArgs)
    {
        FXMLLoader loader= new FXMLLoader();
        loader.setLocation(getClass().getResource("about.fxml"));
        try
        {
            loader.load();
        }
        catch (IOException e)
        {
            throw new IllegalArgumentException("could not create our presentation peer", e);
        }
        mPc = loader.getController();

        mPc.init(this, pArgs);
    }

    /**
     * Called when we should show our (modal) dialog, the call will block until
     * the dialog was closed.
     */
    public void show()
    {
        mPc.show();
    }
}
