package net.sf.cuf.csvviewfx.option;

import net.sf.cuf.appevent.AppEvent;
import net.sf.cuf.appevent.AppEventSupport;
import net.sf.cuf.appevent.AppEventUtil;
import net.sf.cuf.fw.Dc;
import javafx.fxml.FXMLLoader;

import java.io.IOException;
import java.util.Map;

/**
 * Dialog controller for the option dialog.
 */
public class OptionDc implements Dc, AppEventSupport
{
    /** our parent Dc, never null after init was called */
    private AppEventSupport mDcParent;
    /** our presentation controller, never null after init was called */
    private OptionPc        mPc;

    /**
     * Create a new dialog controller, the presentation controller is lazy
     * created in our {@link #init} method.
     */
    public OptionDc()
    {
    }

    /** {@inheritDoc} */
    @Override
    public void init(final Dc pParent, final Map<String, ? super Object> pArgs)
    {
        mDcParent= (AppEventSupport)pParent;

        FXMLLoader loader= new FXMLLoader();
        loader.setLocation(getClass().getResource("option.fxml"));
        try
        {
            loader.load();
        }
        catch (IOException e)
        {
            throw new IllegalArgumentException("could not create our presentation peer", e);
        }
        mPc = loader.getController();

        mPc.init(this, pArgs);
    }


    /**
     * Process an AppEvent.
     * @param pAppEvent event that should be routed/processes
     */
    @Override
    public void postAppEvent(final AppEvent pAppEvent)
    {
        AppEventUtil.postAppEvent(mDcParent, pAppEvent);
    }

    /**
     * Called when we should show our (modal) dialog, the call will block until
     * the dialog was closed.
     */
    public void show()
    {
        mPc.show();
    }
}
