package net.sf.cuf.csvviewfx;

import javafx.stage.FileChooser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * This class contains all keys for either the application model map,
 * for the properties or for the init map.
 */
@SuppressWarnings({"JavaDoc"})
public class AppData
{
    /** argument key for the JavaFx main stage */
    public static final String MAIN_STAGE                   = "mainStage";
    /** our application name */
    public static final String APP_NAME                     = "csvviewfx";
    /** the name of our application properties */
    public static final String APP_USER_PROPERTIES          = '.' +APP_NAME+"_user.properties";

    /** key for the first-row-is-header Boolean app property */
    public static final String FIRST_ROW_IS_HEADER_KEY      = "setFirstRowIsHeader";
    /** default for the first-row-is-header Boolean app property */
    public static final String FIRST_ROW_IS_HEADER_DEFAULT  = "true";

    /** key for the CSV separator String app property */
    public static final String CSV_SEPARATOR_KEY            = "csvSeparator";
    /** default for the CSV separator String app property */
    public static final String CSV_SEPARATOR_DEFAULT        = ",";

    /** key for the whole-row-copy-flag BooleanProperty app model */
    public static final String COPY_WHOLE_ROW_PROPERTY      = "CopyWholeRow";
    /** key for the whole-row-copy-flag Boolean app property */
    public static final String COPY_WHOLE_ROW_KEY           = "copyWholeRow";
    /** default for the whole-row-copy-flag Boolean app property */
    public static final String COPY_WHOLE_ROW_DEFAULT       = "false";

    /** key for the input selection app property */
    public static final String INPUT_SELECTION_KEY      = "InputSelection";
    /** value for the input selection app property if we read from a CSV file */
    public static final String INPUT_SELECTION_FILE     = "file";
    /** value for the input selection app property if we read from a directory tree */
    public static final String INPUT_SELECTION_TREE     = "tree";
    /** default for the input selection app property */
    public static final String INPUT_SELECTION_DEFAULT  = INPUT_SELECTION_FILE;

    /** key for the file name String app property */
    public static final String FILE_NAME_KEY           = "fileName";
    /** default for the file name String app property */
    public static final String FILE_NAME_DEFAULT = "../cuf-csvview/src/test/resources/ca-500.csv";

    /** key for the tree path String app property */
    public static final String TREE_NAME_KEY = "default.treeName";
    /** default for the tree path String app property */
    public static final String TREE_NAME_DEFAULT = System.getProperty("user.home");

    /** key for the encoding name String app property */
    public static final String ENCODING_NAME_KEY       = "encoding";
    /** default for the encoding name String app property */
    public static final String ENCODING_NAME_DEFAULT   = "Cp1252";

    public static final String DEFAULT_WIDTH_KEY     = "windowsize.width";
    public static final String DEFAULT_WIDTH         = "800";
    public static final String DEFAULT_HEIGHT_KEY    = "windowsize.height";
    public static final String DEFAULT_HEIGHT        = "450";
    public static final String DEFAULT_X_KEY         = "windowsize.x";
    public static final String DEFAULT_X             = "40";
    public static final String DEFAULT_Y_KEY         = "windowsize.y";
    public static final String DEFAULT_Y             = "30";
    public static final String DEFAULT_DIR_KEY       = "fileopen.dir";
    public static final String DEFAULT_DIR           = ".";
    public static final String DEFAULT_AUTOFILTER_KEY= "autofilter";
    public static final String DEFAULT_AUTOFILTER    = "true";
    public static final String DEFAULT_FILTER_KEY    = "filter";

    /** shared file chooser filter */
    public static final FileChooser.ExtensionFilter CSV_EXTENSIONS = new FileChooser.ExtensionFilter("CSV Dateien (*.txt, *.csv)", "*.txt", "*.csv");

    /**
     * We only provide constants.
     */
    private AppData()
    {
    }
}
