package net.sf.cuf.csvviewfx.data;

import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/**
 * Common filtering stuff for both the CSV and tree list.
 */
public abstract class AbstractFilteredObservableList implements FilteredObservableList
{
    /** the list containing all rows, never null */
    protected List<Map<String,String>>           mAllRows;
    /** column header names, key is the column index staring with 0 */
    protected Map<Integer, String>               mRowHeaders;
    /** our delegate containing all filter rows */
    protected ObservableList<Map<String,String>> mFilteredRows;

    public int getAllRowsCount()
    {
        return mAllRows.size();
    }

    public int getColumnCount()
    {
        return mRowHeaders.size();
    }

    public String getColumnName(final int pColumnIndex)
    {
        return mRowHeaders.get(pColumnIndex);
    }

    public boolean filter(final String pFilterExpression)
    {
        if (pFilterExpression==null)
        {
            return false;
        }
        Pattern filter;
        try
        {
            filter= Pattern.compile(pFilterExpression,Pattern.CASE_INSENSITIVE);
        }
        catch (PatternSyntaxException ignored)
        {
            return false;
        }
        Matcher match= filter.matcher("");

        List<Map<String,String>> filteredRows= new ArrayList<Map<String, String>>(mAllRows.size());
        for (final Map<String, String> row : mAllRows)
        {
            for (final String field : row.values())
            {
                match.reset(field);
                if (match.find())
                {
                    filteredRows.add(row);
                    break;
                }
            }
        }

        mFilteredRows.clear();
        mFilteredRows.addAll(filteredRows);

        return true;
    }

    public void filterReset()
    {
        mFilteredRows.clear();
        mFilteredRows.addAll(mAllRows);
    }

    /** bellow are all delegated methods for the observable list behaviour */

    @Override
    public void addListener(final ListChangeListener<? super Map<String, String>> pListChangeListener)
    {
        mFilteredRows.addListener(pListChangeListener);
    }

    @Override
    public void removeListener(final ListChangeListener<? super Map<String, String>> pListChangeListener)
    {
        mFilteredRows.removeListener(pListChangeListener);
    }

    @Override
    public boolean addAll(final Map<String, String>... pMaps)
    {
        return mFilteredRows.addAll(pMaps);
    }

    @Override
    public boolean setAll(final Map<String, String>... pMaps)
    {
        return mFilteredRows.setAll(pMaps);
    }

    @Override
    public boolean setAll(final Collection<? extends Map<String, String>> pMaps)
    {
        return mFilteredRows.setAll(pMaps);
    }

    @Override
    public boolean removeAll(final Map<String, String>... pMaps)
    {
        return mFilteredRows.removeAll(pMaps);
    }

    @Override
    public boolean retainAll(final Map<String, String>... pMaps)
    {
        return mFilteredRows.retainAll(pMaps);
    }

    @Override
    public void remove(final int pFrom, final int pTo)
    {
        mFilteredRows.remove(pFrom, pTo);
    }

    @Override
    public int size()
    {
        return mFilteredRows.size();
    }

    @Override
    public boolean isEmpty()
    {
        return mFilteredRows.isEmpty();
    }

    @Override
    public boolean contains(final Object pObject)
    {
        return mFilteredRows.contains(pObject);
    }

    @Override
    public Iterator<Map<String, String>> iterator()
    {
        return mFilteredRows.iterator();
    }

    @Override
    public Object[] toArray()
    {
        return mFilteredRows.toArray();
    }

    @Override
    public <T> T[] toArray(final T[] pArray)
    {
        return mFilteredRows.toArray(pArray);
    }

    @Override
    public boolean add(final Map<String, String> pElement)
    {
        return mFilteredRows.add(pElement);
    }

    @Override
    public boolean remove(final Object pElement)
    {
        return mFilteredRows.remove(pElement);
    }

    @Override
    public boolean containsAll(final Collection<?> pElements)
    {
        return mFilteredRows.containsAll(pElements);
    }

    @Override
    public boolean addAll(final Collection<? extends Map<String, String>> pElements)
    {
        return mFilteredRows.addAll(pElements);
    }

    @Override
    public boolean addAll(final int index, final Collection<? extends Map<String, String>> pElements)
    {
        return mFilteredRows.addAll(index, pElements);
    }

    @Override
    public boolean removeAll(final Collection<?> pElements)
    {
        return mFilteredRows.removeAll(pElements);
    }

    @Override
    public boolean retainAll(final Collection<?> pElements)
    {
        return mFilteredRows.retainAll(pElements);
    }

    @Override
    public void clear()
    {
        mFilteredRows.clear();
    }

    @Override
    public boolean equals(final Object pOther)
    {
        return mFilteredRows.equals(pOther);
    }

    @Override
    public int hashCode()
    {
        return mFilteredRows.hashCode();
    }

    @Override
    public Map<String, String> get(final int pIndex)
    {
        return mFilteredRows.get(pIndex);
    }

    @Override
    public Map<String, String> set(final int pIndex, final Map<String, String> pElement)
    {
        return mFilteredRows.set(pIndex, pElement);
    }

    @Override
    public void add(final int pIndex, final Map<String, String> pElement)
    {
        mFilteredRows.add(pIndex, pElement);
    }

    @Override
    public Map<String, String> remove(final int pIndex)
    {
        return mFilteredRows.remove(pIndex);
    }

    @Override
    public int indexOf(final Object pElement)
    {
        return mFilteredRows.indexOf(pElement);
    }

    @Override
    public int lastIndexOf(final Object pElement)
    {
        return mFilteredRows.lastIndexOf(pElement);
    }

    @Override
    public ListIterator<Map<String, String>> listIterator()
    {
        return mFilteredRows.listIterator();
    }

    @Override
    public ListIterator<Map<String, String>> listIterator(final int pIndex)
    {
        return mFilteredRows.listIterator(pIndex);
    }

    @Override
    public List<Map<String, String>> subList(final int pFromIndex, final int pToindex)
    {
        return mFilteredRows.subList(pFromIndex, pToindex);
    }

    @Override
    public void addListener(final InvalidationListener pInvalidationListener)
    {
        mFilteredRows.addListener(pInvalidationListener);
    }

    @Override
    public void removeListener(final InvalidationListener pInvalidationListener)
    {
        mFilteredRows.removeListener(pInvalidationListener);
    }
}
