/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvviewfx.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.collections.FXCollections;
import net.sf.cuf.csvviewfx.data.AbstractFilteredObservableList;

public class CsvFileredObservableList
extends AbstractFilteredObservableList {
    private static final String CSV_SEPARATOR = ",";
    private static final String EMPTY = "";
    private static final Pattern CSV_QUOTE_PATTERN = Pattern.compile("\"\"");

    public CsvFileredObservableList() {
        this.init();
    }

    public CsvFileredObservableList(InputStream pCSVData, boolean pFirstRowIsHeader, String pCSVSeparator, String pEncoding) throws IOException {
        if (pCSVData == null) {
            this.init();
        } else {
            this.init(new InputStreamReader(pCSVData, pEncoding), pFirstRowIsHeader, pCSVSeparator);
        }
    }

    public CsvFileredObservableList(Reader pCSVData, boolean pFirstRowIsHeader, String pCSVSeparator) throws IOException {
        if (pCSVData == null) {
            this.init();
        } else {
            this.init(pCSVData, pFirstRowIsHeader, pCSVSeparator);
        }
    }

    private void init() {
        this.mRowHeaders = Collections.emptyMap();
        this.mAllRows = Collections.emptyList();
        this.mFilteredRows = FXCollections.observableArrayList((Collection)this.mAllRows);
    }

    /*
     * Could not resolve type clashes
     */
    private void init(Reader pCSVData, boolean pFirstRowIsHeader, String pCSVSeparator) throws IOException {
        int i;
        if (pCSVData == null) {
            throw new IllegalArgumentException("pCSVReader must not be null");
        }
        String csvSeparator = pCSVSeparator == null ? CSV_SEPARATOR : pCSVSeparator;
        ArrayList data = new ArrayList();
        LineNumberReader reader = new LineNumberReader(pCSVData);
        int maxColumns = 0;
        String csvMainString = "  \\G(?:^|" + csvSeparator + ")\n" + "  (?:\n" + "     # Either a double-quoted field...\n" + "     \" # field's opening quote\n" + "      (  (?> [^\"]*+ ) (?> \"\" [^\"]*+ )*+  )\n" + "     \" # field's closing quote\n" + "   # ... or ...\n" + "   |\n" + "     # ... some non-quote/non-comma text ...\n" + "     ( [^\"" + csvSeparator + "]*+ )\n" + "  )\n";
        Pattern csvMainPattern = Pattern.compile(csvMainString, 4);
        Matcher csvQuote = CSV_QUOTE_PATTERN.matcher(EMPTY);
        Matcher csvMain = csvMainPattern.matcher(EMPTY);
        String line = reader.readLine();
        while (line != null) {
            ArrayList<String> row = new ArrayList<String>();
            csvMain.reset(line);
            while (csvMain.find()) {
                String field;
                String first = csvMain.group(2);
                if (first != null) {
                    field = first;
                } else {
                    csvQuote.reset(csvMain.group(1));
                    field = csvQuote.replaceAll("\"");
                }
                if (EMPTY.equals(field)) {
                    field = EMPTY;
                }
                row.add(field);
            }
            if (!row.isEmpty() && ((String)row.get(row.size() - 1)).equals(EMPTY)) {
                row.remove(row.size() - 1);
            }
            if (pFirstRowIsHeader && this.mRowHeaders == null) {
                this.mRowHeaders = new HashMap();
                int n = row.size();
                for (int i2 = 0; i2 < n; ++i2) {
                    String header = (String)row.get(i2);
                    this.mRowHeaders.put(i2, header);
                }
            } else {
                data.add(row);
            }
            maxColumns = Math.max(maxColumns, row.size());
            line = reader.readLine();
        }
        if (pFirstRowIsHeader) {
            for (i = this.mRowHeaders.size(); i < maxColumns; ++i) {
                this.mRowHeaders.put(i, Integer.toString(i));
            }
        } else {
            this.mRowHeaders = new HashMap();
            for (i = 0; i < maxColumns; ++i) {
                this.mRowHeaders.put(i, Integer.toString(i));
            }
        }
        this.mAllRows = new ArrayList(data.size());
        for (List row : data) {
            HashMap mapRow = new HashMap(this.mRowHeaders.size());
            int n = row.size();
            for (int i3 = 0; i3 < n; ++i3) {
                String entry = (String)row.get(i3);
                mapRow.put(this.mRowHeaders.get(i3), entry);
            }
            this.mAllRows.add(mapRow);
        }
        this.mFilteredRows = FXCollections.observableArrayList((Collection)this.mAllRows);
    }
}

