package net.sf.cuf.csvviewfx.main;

import net.sf.cuf.csvviewfx.data.FilteredObservableList;
import net.sf.cuf.csvviewfx.data.TreeFilteredObservableList;
import net.sf.cuf.xfer.AbstractRequest;
import net.sf.cuf.xfer.DefaultResponse;
import net.sf.cuf.xfer.Response;

import java.io.File;

/**
 * A LoadTreeRequest creates a FilteredObservableList.
 */
public class LoadTreeRequest extends AbstractRequest implements LoadDataRequest
{
    /** the directory node we start from */
    private File mRootNode;

    /**
     * Creates a new LoadTreeRequest, the tree is loaded in execute().
     * @param pRootNode the directory we should start from, must not be null
     * @throws IllegalArgumentException if pFile is null
     */
    public LoadTreeRequest(final File pRootNode)
    {
        super();
        if (pRootNode==null)
        {
            throw new IllegalArgumentException("root node must not be null");
        }
        mRootNode= pRootNode;
    }

    /**
     * Generate a TreeFilteredObservableList with the file given in the constructor.
     * @return a DefaultResponse with a FilteredObservableList as its result if
     *         everything worked, or an Exception as its error if we got problems
     */
    public Response execute()
    {
        DefaultResponse response= new DefaultResponse();
        try
        {
            FilteredObservableList model= new TreeFilteredObservableList(mRootNode);
            response.setResult(model);
        }
        catch (Exception e)
        {
            response.setError(e);
        }

        return response;
    }
}
