package net.sf.cuf.csvviewfx;

import net.sf.cuf.fw2.UserProperties;
import net.sf.cuf.fw.AbstractFxApplication;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.fxml.FXMLLoader;
import javafx.stage.Stage;
import net.sf.cuf.csvviewfx.main.MainDc;
import net.sf.cuf.csvviewfx.main.MainPc;

import java.util.HashMap;
import java.util.Map;

/**
 * Main class of the csvview (JavaFX) application. This class manages
 * the start/stop process and is a creator and storage of the
 * application models and properties.
 */
public class MainFx extends AbstractFxApplication
{
    /** {@inheritDoc} */
    @Override
    public void start(final Stage pStage) throws Exception
    {
        // load properties
        mAppProperties = UserProperties.read(null, null, AppData.APP_USER_PROPERTIES);

        // init our application domain models
        BooleanProperty copyRow= new SimpleBooleanProperty(
                Boolean.parseBoolean(mAppProperties.getProperty(AppData.COPY_WHOLE_ROW_KEY, AppData.COPY_WHOLE_ROW_DEFAULT)));
        mAppModels.put(AppData.COPY_WHOLE_ROW_PROPERTY, copyRow);


        // load the main UI and create the controllers
        FXMLLoader loader= new FXMLLoader();
        loader.setLocation(getClass().getResource("main/csvview.fxml"));
        loader.load();
        final MainPc mainPc = loader.getController();
        MainDc mainDc= new MainDc(mainPc);

        // init the dialog hierarchy, we are already in the App Thread
        final Map<String, ? super  Object> args= new HashMap<String, Object>();
        args.put(APPLICATION_KEY, this);
        args.put(AppData.MAIN_STAGE, pStage);
        mainDc.init(null, args);
    }

    /** {@inheritDoc} */
    @Override
    public void stop() throws Exception
    {
        super.stop();

        mAppProperties.setProperty(AppData.COPY_WHOLE_ROW_KEY, Boolean.toString(
                ((BooleanProperty)mAppModels.get(AppData.COPY_WHOLE_ROW_PROPERTY)).getValue()));

        // save our properties
        UserProperties.write(mAppProperties, null, AppData.APP_USER_PROPERTIES);
    }

    /**
     * Main entry point to the application.
     * @param pArgs the arguments
     */
    public static void main(final String[] pArgs)
    {
        launch(pArgs);
    }
}
