package net.sf.cuf.csvviewfx.data;

import javafx.collections.ObservableList;

import java.util.Map;

/**
 * Base interface of all the Lists we use in our application.
 * It adds the filtering capabilities to the basic observable list.
 */
public interface FilteredObservableList extends ObservableList<Map<String,String>>
{
    /**
     * Filter the data with the handed regular expression.
     * @param pFilterExpression the regular expression we should filter our rows with, may be null
     * @return true if the filter expression was valid, false if not
     */
    boolean filter(String pFilterExpression);

    /**
     * Reset any filtering. Can be called also when no filter was set
     * before.
     */
    void filterReset();

    /**
     * Return the number of all rows, including those that are currently
     * filtered.
     * @return the number of total (not filtered) rows
     */
    int getAllRowsCount();

    /**
     * Return the number of columns.
     * @return the number of columns
     */
    int getColumnCount();

    /**
     * Return the name of the column.
     * @param pColumn the column, must be less than the column count
     * @return the column name, or null if the column is out of range
     */
    String getColumnName(int pColumn);
}
