/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvviewfx.about;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.SequentialTransitionBuilder;
import javafx.animation.Transition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import net.sf.cuf.csvviewfx.Version;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw.Pc;

public class AboutPc
implements Pc {
    private static final Duration FADE_DURATION = Duration.seconds((double)3.0);
    @FXML
    private Image mAppIcon;
    @FXML
    private Image mAboutImage;
    @FXML
    private Image mAuthorImage;
    @FXML
    private Label mAboutLabel;
    @FXML
    private ImageView mAboutLogo;
    @FXML
    public StackPane mRootContainer;
    @FXML
    private Label mVersion;
    @FXML
    private Label mJdk;
    private Stage mStage;
    private Stage mMainStage;
    private List<Transition> mTransitions = new ArrayList<Transition>();

    public void init(Dc pDc, Map<String, ? super Object> pArgs) {
        this.mMainStage = (Stage)pArgs.get("mainStage");
        StringBuilder versionText = new StringBuilder(this.mVersion.getText());
        versionText.append(", Version ");
        versionText.append(Version.VERSION);
        versionText.append(" (");
        versionText.append(Version.DATE);
        versionText.append(" )");
        this.mVersion.setText(versionText.toString());
        StringBuilder jdkText = new StringBuilder("Java VM from ");
        jdkText.append(System.getProperty("java.vendor"));
        jdkText.append(", Version ");
        jdkText.append(System.getProperty("java.version"));
        this.mJdk.setText(jdkText.toString());
        double maxWidth = Math.max(this.mAuthorImage.getWidth(), this.mAboutImage.getWidth());
        double maxHeight = Math.max(this.mAuthorImage.getHeight(), this.mAboutImage.getHeight());
        this.mAboutLabel.setMinHeight(maxHeight);
        this.mAboutLabel.setMinWidth(maxWidth);
        final Transition transitionForward = this.createTransition(this.mAboutLogo, this.mAuthorImage);
        final Transition transitionBackward = this.createTransition(this.mAboutLogo, this.mAboutImage);
        this.mTransitions.add(transitionBackward);
        this.mTransitions.add(transitionBackward);
        this.mAboutLabel.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent pMouseEvent) {
                if (AboutPc.this.mAboutLogo.getImage().equals(AboutPc.this.mAboutImage)) {
                    transitionForward.play();
                } else {
                    transitionBackward.play();
                }
            }
        });
    }

    private Transition createTransition(final ImageView pImageView, final Image pNewImage) {
        FadeTransition fadeOutTransition = new FadeTransition(FADE_DURATION, (Node)pImageView);
        fadeOutTransition.setFromValue(1.0);
        fadeOutTransition.setToValue(0.0);
        fadeOutTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent pActionEvent) {
                pImageView.setImage(pNewImage);
            }
        });
        FadeTransition fadeInTransition = new FadeTransition(FADE_DURATION, (Node)pImageView);
        fadeInTransition.setFromValue(0.0);
        fadeInTransition.setToValue(1.0);
        SequentialTransition sequentialTransition = SequentialTransitionBuilder.create().children(new Animation[]{fadeOutTransition, fadeInTransition}).build();
        return sequentialTransition;
    }

    void show() {
        this.mStage = new Stage();
        this.mStage.initOwner((Window)this.mMainStage);
        Scene scene = new Scene((Parent)this.mRootContainer);
        this.mStage.setScene(scene);
        this.mStage.setTitle("\u00dcber");
        this.mStage.initModality(Modality.WINDOW_MODAL);
        this.mStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent pWindowEvent) {
                pWindowEvent.consume();
                AboutPc.this.ok();
            }
        });
        this.mStage.getIcons().add((Object)this.mAppIcon);
        this.mAboutLogo.setImage(this.mAboutImage);
        this.mStage.showAndWait();
        this.mStage = null;
    }

    public void ok() {
        this.mStage.hide();
        for (Transition transition : this.mTransitions) {
            transition.stop();
        }
    }
}

