package net.sf.cuf.csvviewfx.main;

import net.sf.cuf.csvviewfx.data.CsvFileredObservableList;
import net.sf.cuf.csvviewfx.data.FilteredObservableList;
import net.sf.cuf.xfer.DefaultResponse;
import net.sf.cuf.xfer.Response;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * A LoadFileRequest creates a CsvFileredObservableList.
 */
public class LoadFileRequest extends AbstractLoadRequest implements LoadDataRequest
{
    /** file we should load the data from, never null */
    private File        mFile;

    /**
     * Creates a new LoadFileRequest, the CSV data is loaded in execute() from
     * the handed file.
     * @param pFile file to load the data from
     * @param pFirstRowIsHeader true if the first row contains the header
     * @param pCSVSeparator "comma" separator, may be null
     * @param pEncoding the encoding, must not be nul
     * @throws IllegalArgumentException if pFile is null
     */
    public LoadFileRequest(final File pFile, final boolean pFirstRowIsHeader, final String pCSVSeparator, final String pEncoding)
    {
        super(pCSVSeparator, pEncoding, pFirstRowIsHeader);
        if (pFile==null)
        {
            throw new IllegalArgumentException("file must not be null");
        }
        mFile= pFile;
    }

    /**
     * Generate a CsvFileredObservableList with the file given in the constructor.
     * @return a DefaultResponse with a FilteredObservableList as its result if
     *         everything worked, or an Exception as its error if we got problems
     */
    public Response execute()
    {
        DefaultResponse response= new DefaultResponse();
        InputStream     input   = null;
        try
        {
            input= new FileInputStream(mFile);
            FilteredObservableList model= new CsvFileredObservableList(input, mFirstRowIsHeader, mCSVSeparator, mEncoding);
            response.setResult(model);
        }
        catch (Exception e)
        {
            response.setError(e);
        }
        finally
        {
            if (input!=null)
            {
                try
                {
                    input.close();
                }
                catch (IOException ignored) { }
            }
        }

        return response;
    }
}
