/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvview.browse;

import java.io.InputStream;
import java.net.URL;
import net.sf.cuf.csvview.browse.AbstractLoadRequest;
import net.sf.cuf.csvview.browse.LoadDataRequest;
import net.sf.cuf.csvview.util.CSVTableModel;
import net.sf.cuf.xfer.DefaultResponse;
import net.sf.cuf.xfer.Response;

public class LoadURLRequest<T>
extends AbstractLoadRequest<T>
implements LoadDataRequest<T> {
    private String mURLName;

    public LoadURLRequest(String pURLName, boolean pFirstRowIsHeader, String pCSVSeparator, String pEncoding) {
        super(pCSVSeparator, pEncoding, pFirstRowIsHeader);
        if (pURLName == null) {
            throw new IllegalArgumentException("URL must not be null");
        }
        this.mURLName = pURLName;
    }

    public Response<T> execute() {
        DefaultResponse response = new DefaultResponse();
        try {
            URL url = new URL(this.mURLName);
            InputStream input = url.openStream();
            CSVTableModel model = new CSVTableModel(input, this.mFirstRowIsHeader, this.mCSVSeparator, this.mEncoding);
            input.close();
            response.setResult((Object)model);
        }
        catch (Exception e) {
            response.setError((Object)e);
        }
        return response;
    }
}

