package net.sf.cuf.csvview.option;

import net.sf.cuf.appevent.AppEvent;
import net.sf.cuf.appevent.AppEventSupport;
import net.sf.cuf.appevent.AppEventUtil;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.fw.Dc;

import java.util.Map;

/**
 * Dialog component of the options panel.
 */
public class OptionDc implements Dc, AppEventSupport, net.sf.cuf.ui.builder.SwingXMLBuilder.Backlink
{
    /** our presentation component peer */
    private OptionPc        mPc;
    /** our mapping helper */
    private SwingXMLBuilder mBuilder;
    /** our parent Dc */
    private AppEventSupport mDcParent;

    /**
     * When a SwingXMLBuilder creates an object of ourselves, we want to
     * know that builder.
     * @param pBuilder the builder that created this object
     */
    public void setSwingXMLBuilder(final SwingXMLBuilder pBuilder)
    {
        mBuilder= pBuilder;
    }

    /**
     * This method initializes its presentation component and stores
     * the parent for AppEvent routing.
     * @param pParent our parent dialog component
     * @param pArgs the arguments
     */
    public void init(final Dc pParent, final Map<String, ? super Object>  pArgs)
    {
        mDcParent= (AppEventSupport)pParent;
        mPc= (OptionPc)mBuilder.getNonVisualObject("OptionPc");
        mPc.init(this, pArgs);
    }

    /**
     * Process an AppEvent.
     * @param pAppEvent event that should be routed/processes
     */
    public void postAppEvent(final AppEvent pAppEvent)
    {
        AppEventUtil.postAppEvent(mDcParent, pAppEvent);
    }
}
