package net.sf.cuf.csvview;

/**
 * This class contains all keys for either the application model map,
 * for the properties or for the init map.
 */
@SuppressWarnings({"JavaDoc"})
public class AppData
{
    public static final String APP_NAME                  = "csvview";
    public static final String XML_UI_NAME               = APP_NAME+".xml";
    public static final String CSVVIEW_USER_PROPERTIES   = '.' +APP_NAME+"_user.properties";

    public static final String FIRST_ROW_IS_HEADER_VM  = "FirstRowIsHeader";
    public static final String FIRST_ROW_IS_HEADER_KEY = "setFirstRowIsHeader"; // see csvview.xml
    public static final String FIRST_ROW_IS_HEADER     = "true"; // duplicated in csvview.xml
    public static final String CSV_SEPARATOR_VM        = "CSVSeparator";
    public static final String CSV_SEPARATOR_KEY       = "csvSeparator"; // see csvview.xml
    public static final String CSV_SEPARATOR           = ","; // duplicated in csvview.xml
    public static final String INPUT_ITEMS             = "inputItems";
    public static final String INPUT_KEYS              = "inputKeys";
    public static final String INPUT_SELECTION         = "InputSelection";
    public static final String CSV_SOURCE_KEY          = "csvSource";
    public static final String CSV_SOURCE_FILE         = "file";
    public static final String CSV_SOURCE_URL          = "url";
    public static final String CSV_SOURCE_TREE         = "tree";
    public static final String DEFAULT_FILE_NAME_KEY   = "default.fileName";
    public static final String DEFAULT_FILE_NAME       = "src/test/resources/ca-500.csv";
    public static final String DEFAULT_URL_NAME_KEY    = "default.urlName";
    public static final String DEFAULT_URL_NAME        = "";
    public static final String DEFAULT_TREE_NAME_KEY   = "default.treeName";
    public static final String DEFAULT_TREE_NAME       = "";
    public static final String EXE_PROGRAM_ACTIVE_KEY  = "exeProgramActive";
    public static final String EXE_PROGRAM_ACTIVE      = "false";
    public static final String EXE_PROGRAM_NAME_KEY    = "exeProgramName";
    public static final String EXE_PROGRAM_NAME        = "";
    public static final String PLAF_NAME_KEY           = "plaf";
    public static final String PLAF_DEFAULT_NAME       = "com.jgoodies.looks.plastic.Plastic3DLookAndFeel";
    public static final String PLAF_ITEMS              = "plafItems";
    public static final String PLAF_KEYS               = "plafKeys";
    public static final String PLAF_SELECTION_KEY      = "PlafSelection";
    public static final String ENCODING_NAME_KEY       = "encoding";
    public static final String ENCODING_DEFAULT_NAME   = "Cp1252";
    public static final String ENCODING_ITEMS          = "encodingItems";
    public static final String ENCODING_KEYS           = "encodingKeys";
    public static final String ENCODING_SELECTION      = "EncodingSelection";
    public static final String COPY_WHOLE_ROW_VM       = "CopyWholeRow";
    public static final String COPY_WHOLE_ROW_KEY      = "copyWholeRow"; // see csvview.xml
    public static final String COPY_WHOLE_ROW          = "false"; // duplicated in csvview.xml

    public static final String DEFAULT_WIDTH_KEY     = "windowsize.width";
    public static final String DEFAULT_WIDTH         = "800";
    public static final String DEFAULT_HEIGHT_KEY    = "windowsize.height";
    public static final String DEFAULT_HEIGHT        = "450";
    public static final String DEFAULT_X_KEY         = "windowsize.x";
    public static final String DEFAULT_X             = "40";
    public static final String DEFAULT_Y_KEY         = "windowsize.y";
    public static final String DEFAULT_Y             = "30";
    public static final String DEFAULT_DIR_KEY       = "fileopen.dir";
    public static final String DEFAULT_DIR           = ".";
    public static final String DEFAULT_AUTOFILTER_KEY= "autofilter";
    public static final String DEFAULT_FILTER_KEY    = "filter";
    public static final String DEFAULT_TABLE_SETTINGS= "tablesettings";

    /**
     * We only provide constants.
     */
    private AppData()
    {
    }
}
