/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvview.browse;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import javax.swing.ActionMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;
import net.sf.cuf.csvview.browse.MainDc;
import net.sf.cuf.csvview.util.CSVFileFilter;
import net.sf.cuf.csvview.util.FilteredTableModel;
import net.sf.cuf.csvview.util.TableRowCopyAction;
import net.sf.cuf.fw.Application;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw.Pc;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.ui.DispatcherAction;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.ui.table.ContextMenuAction;
import net.sf.cuf.ui.table.ContextMenuActionHideColumn;
import net.sf.cuf.ui.table.ContextMenuActionOptimalColumnWidth;
import net.sf.cuf.ui.table.ContextMenuActionSortColumn;
import net.sf.cuf.ui.table.ContextMenuActionSortDialog;
import net.sf.cuf.ui.table.ContextMenuActionVisibilityDialog;
import net.sf.cuf.ui.table.OptimalColumnWidthSupport;
import net.sf.cuf.ui.table.TableContextMenu;
import net.sf.cuf.ui.table.TableProperties;
import net.sf.cuf.xfer.Response;

public class MainPc
implements Pc,
SwingXMLBuilder.Backlink {
    static final String TABLE_ARG = "tableModel";
    private SwingXMLBuilder mBuilder;
    private MainDc mDc;
    private Application mApp;
    private FilteredTableModel mTableModel;
    private String mOldFilterText;
    private Color mOldBackground;
    private String mOldTooltip;
    private boolean mAutoFilter;
    private static final String REPLACE_ROW = "%r";
    private static final String REPLACE_CELL = "%s";

    public void setSwingXMLBuilder(SwingXMLBuilder pBuilder) {
        this.mBuilder = pBuilder;
    }

    public void init(Dc pDc, Map<String, ? super Object> pArgs) {
        this.mDc = (MainDc)pDc;
        this.mTableModel = (FilteredTableModel)pArgs.get(TABLE_ARG);
        this.mApp = (Application)pArgs.get("Application");
        ValueModel model = (ValueModel)this.mApp.getAppModel().get("FirstRowIsHeader");
        model.onChangeSend((Object)this, "setFirstRowIsHeader");
        ValueModel plafSelection = (ValueModel)this.mApp.getAppModel().get("PlafSelection");
        plafSelection.onChangeSend((Object)this, "plafChanged");
        this.setModelIntern(this.mTableModel, false);
        JTable table = (JTable)this.mBuilder.getComponentByName("Frame/Panel/ScrollPane/CSVTabelle");
        new OptimalColumnWidthSupport(table);
        ContextMenuAction[] actions = new ContextMenuAction[]{new ContextMenuActionSortColumn(true), new ContextMenuActionSortColumn(false), new ContextMenuActionHideColumn(), new ContextMenuActionOptimalColumnWidth(), TableContextMenu.SEPARATOR, new ContextMenuActionSortDialog(), new ContextMenuActionVisibilityDialog()};
        new TableContextMenu(table, 7, actions);
        table.setAutoResizeMode(0);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    MainPc.this.doubleClicked();
                }
            }
        });
        ActionMap map = table.getActionMap();
        ValueModel copyHolder = (ValueModel)this.mApp.getAppModel().get("CopyWholeRow");
        map.put(TransferHandler.getCopyAction().getValue("Name"), new TableRowCopyAction(copyHolder));
        this.updateStatusLabel();
        this.mAutoFilter = Boolean.valueOf(this.mApp.getProperty("autofilter", "true"));
        DispatcherAction autoFilter = (DispatcherAction)this.mBuilder.getNonVisualObject("AutoFilter");
        autoFilter.setSelected(this.mAutoFilter);
        this.mOldFilterText = null;
        JTextField filter = (JTextField)this.mBuilder.getComponentByName("Frame/Panel/Input");
        this.mOldBackground = filter.getBackground();
        this.mOldTooltip = filter.getToolTipText();
        String filterText = this.mApp.getProperty("filter", "");
        if (!"".equals(filterText)) {
            filter.setText(filterText);
            filter.selectAll();
        }
        JFrame frame = (JFrame)this.mBuilder.getContainerByName("Frame");
        int x = Integer.parseInt("40");
        int y = Integer.parseInt("30");
        int width = Integer.parseInt("800");
        int height = Integer.parseInt("800");
        try {
            x = Integer.parseInt(this.mApp.getProperty("windowsize.x", "40"));
            y = Integer.parseInt(this.mApp.getProperty("windowsize.y", "30"));
            width = Integer.parseInt(this.mApp.getProperty("windowsize.width", "800"));
            height = Integer.parseInt(this.mApp.getProperty("windowsize.height", "450"));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        frame.setLocation(x, y);
        frame.setSize(width, height);
        frame.setVisible(true);
    }

    public void quit() {
        JFrame frame = (JFrame)this.mBuilder.getContainerByName("Frame");
        int width = frame.getWidth();
        int height = frame.getHeight();
        int x = frame.getX();
        int y = frame.getY();
        this.mApp.setProperty("windowsize.x", Integer.toString(x));
        this.mApp.setProperty("windowsize.y", Integer.toString(y));
        this.mApp.setProperty("windowsize.width", Integer.toString(width));
        this.mApp.setProperty("windowsize.height", Integer.toString(height));
        JTable table = (JTable)this.mBuilder.getComponentByName("Frame/Panel/ScrollPane/CSVTabelle");
        TableProperties.store((JTable)table, (Properties)this.mApp.getProperties(), (String)"tablesettings");
        this.mDc.quit();
    }

    public void openFile() {
        JFrame frame = (JFrame)this.mBuilder.getContainerByName("Frame");
        String dir = this.mApp.getProperty("fileopen.dir", ".");
        JFileChooser fileChooser = new JFileChooser(dir);
        fileChooser.addChoosableFileFilter(new CSVFileFilter());
        int back = fileChooser.showOpenDialog(frame);
        if (back == 0) {
            File file = fileChooser.getSelectedFile();
            this.mDc.openFile(file);
            this.mApp.setProperty("fileopen.dir", file.getParent());
        }
    }

    public void openTree() {
        JFrame frame = (JFrame)this.mBuilder.getContainerByName("Frame");
        String dir = this.mApp.getProperty("fileopen.dir", ".");
        JFileChooser fileChooser = new JFileChooser(dir);
        fileChooser.setFileSelectionMode(1);
        int back = fileChooser.showOpenDialog(frame);
        if (back == 0) {
            File file = fileChooser.getSelectedFile();
            this.mDc.openTree(file);
            this.mApp.setProperty("fileopen.dir", file.getParent());
        }
    }

    public void setModel(FilteredTableModel pModel) {
        this.setModelIntern(pModel, true);
    }

    private void setModelIntern(FilteredTableModel pModel, boolean pDoFilter) {
        this.mTableModel = pModel;
        JTable table = (JTable)this.mBuilder.getComponentByName("Frame/Panel/ScrollPane/CSVTabelle");
        table.setModel(this.mTableModel);
        if (pDoFilter) {
            this.doFilter();
        }
        TableProperties.load((JTable)table, (Properties)this.mApp.getProperties(), (String)"tablesettings");
    }

    public void filter() {
        JTextField filter = (JTextField)this.mBuilder.getComponentByName("Frame/Panel/Input");
        String filterText = filter.getText();
        if (!this.mAutoFilter || filterText.equals(this.mOldFilterText)) {
            return;
        }
        this.doFilter();
    }

    public void search() {
        this.doFilter();
    }

    private void doFilter() {
        String filterText;
        JTextField filter = (JTextField)this.mBuilder.getComponentByName("Frame/Panel/Input");
        this.mOldFilterText = filterText = filter.getText();
        if ("".equals(filterText)) {
            this.mTableModel.filterReset();
        } else {
            boolean filterOK = this.mTableModel.filter(filterText);
            if (filterOK) {
                filter.setBackground(this.mOldBackground);
                filter.setToolTipText(this.mOldTooltip);
            } else {
                filter.setBackground(Color.cyan);
                filter.setToolTipText("Eingabe ist keine gueltiger regulaerer Ausdruck");
            }
        }
        this.mApp.setProperty("filter", filterText);
        this.updateStatusLabel();
    }

    public void updateStatusLabel() {
        JLabel label = (JLabel)this.mBuilder.getComponentByName("Frame/Panel/Status");
        int allRows = this.mTableModel.getAllRowsCount();
        int rows = this.mTableModel.getRowCount();
        JTable table = (JTable)this.mBuilder.getComponentByName("Frame/Panel/ScrollPane/CSVTabelle");
        int selected = table.getSelectedRowCount();
        label.setText(allRows + " Zeilen, davon " + rows + " gefiltered" + " und " + selected + " selektiert");
    }

    public void autoFilter() {
        this.mOldFilterText = null;
        DispatcherAction autoFilter = (DispatcherAction)this.mBuilder.getNonVisualObject("AutoFilter");
        boolean isSelected = autoFilter.isSelected();
        if (isSelected) {
            this.mAutoFilter = true;
            this.doFilter();
        } else {
            this.mAutoFilter = false;
        }
        this.mApp.setProperty("autofilter", Boolean.toString(isSelected));
    }

    public void showLoadError(Response<?> pResponse) {
        StringBuilder sb = new StringBuilder();
        sb.append("BAD NEWS!\n");
        sb.append("W\u00e4hrend des Ladens ging etwas schief:\n");
        if (pResponse.getError() == null) {
            sb.append("Aber wir wissen nicht was :-(");
        } else {
            sb.append(pResponse.getError());
        }
        JFrame frame = (JFrame)this.mBuilder.getContainerByName("Frame");
        JOptionPane.showMessageDialog(frame, sb.toString(), "ERROR", 0);
    }

    public void setFirstRowIsHeader(ChangeEvent e) {
        ValueModel model = (ValueModel)e.getSource();
        boolean firstRowIsHeader = model.booleanValue();
        this.mTableModel.setFirstRowIsHeader(firstRowIsHeader);
        JTable table = (JTable)this.mBuilder.getComponentByName("Frame/Panel/ScrollPane/CSVTabelle");
        table.createDefaultColumnsFromModel();
    }

    private void doubleClicked() {
        JTable table = (JTable)this.mBuilder.getComponentByName("Frame/Panel/ScrollPane/CSVTabelle");
        int selectedRow = table.getSelectedRow();
        int selectedColumn = table.getSelectedColumn();
        boolean exeActive = this.mApp.getProperty("exeProgramActive", "false").equals(Boolean.TRUE.toString());
        if (exeActive && selectedRow > -1 && selectedColumn > -1) {
            int realRow = selectedRow;
            int realColumn = table.convertColumnIndexToModel(selectedColumn);
            String cellData = table.getModel().getValueAt(realRow, realColumn).toString();
            String template = this.mApp.getProperty("exeProgramName", "");
            String command = MainPc.replaceAll(template, REPLACE_CELL, cellData);
            if (command.contains(REPLACE_ROW)) {
                TableModel model = table.getModel();
                StringBuilder sb = new StringBuilder();
                int n = model.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    sb.append(table.getValueAt(realRow, i));
                    if (i >= n - 1) continue;
                    sb.append(',');
                }
                command = MainPc.replaceAll(command, REPLACE_ROW, sb.toString());
            }
            this.mDc.exeProgram(command);
        }
    }

    private static String replaceAll(String pData, String pReplaceWhat, String pReplaceWith) {
        StringBuilder sb = new StringBuilder();
        int start = 0;
        int index = pData.indexOf(pReplaceWhat, start);
        while (index >= 0) {
            sb.append(pData.substring(start, index));
            sb.append(pReplaceWith);
            start = index + pReplaceWhat.length();
            index = pData.indexOf(pReplaceWhat, start);
        }
        if (start < pData.length()) {
            sb.append(pData.substring(start));
        }
        return sb.toString();
    }

    public void plafChanged(ChangeEvent e) {
        ValueModel plafSelection = (ValueModel)this.mApp.getAppModel().get("PlafSelection");
        String plafName = (String)plafSelection.getValue();
        try {
            UIManager.setLookAndFeel(plafName);
            SwingUtilities.updateComponentTreeUI(this.mBuilder.getContainerByName("Frame"));
            SwingUtilities.updateComponentTreeUI(this.mBuilder.getContainerByName("Frame/OptionsDialog"));
            SwingUtilities.updateComponentTreeUI(this.mBuilder.getContainerByName("Frame/AboutDialog"));
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }
}

