/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvview.browse;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.sf.cuf.appevent.AppEvent;
import net.sf.cuf.appevent.AppEventManager;
import net.sf.cuf.appevent.AppEventSupport;
import net.sf.cuf.appevent.AppEventUtil;
import net.sf.cuf.appevent.BindEvent;
import net.sf.cuf.csvview.browse.LoadDataRequest;
import net.sf.cuf.csvview.browse.LoadFileRequest;
import net.sf.cuf.csvview.browse.LoadTreeRequest;
import net.sf.cuf.csvview.browse.LoadURLRequest;
import net.sf.cuf.csvview.browse.MainPc;
import net.sf.cuf.csvview.util.CSVTableModel;
import net.sf.cuf.csvview.util.DataSourceChanged;
import net.sf.cuf.csvview.util.FilteredTableModel;
import net.sf.cuf.fw.Application;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.xfer.AbstractRequest;
import net.sf.cuf.xfer.Dispatch;
import net.sf.cuf.xfer.Response;
import net.sf.cuf.xfer.SwingDispatcher;

public class MainDc
implements Dc,
AppEventSupport,
SwingXMLBuilder.Backlink {
    private MainPc mPc;
    private SwingXMLBuilder mBuilder;
    private AppEventManager mAppEventManger;
    private Application mApp;
    private Dispatch mDispatcher;

    public void setSwingXMLBuilder(SwingXMLBuilder pBuilder) {
        this.mBuilder = pBuilder;
    }

    public void postAppEvent(AppEvent pAppEvent) {
        AppEventUtil.postAppEvent((AppEventSupport)this.mAppEventManger, (AppEvent)pAppEvent);
    }

    public void init(Dc pParent, Map<String, ? super Object> pArgs) {
        this.mDispatcher = new SwingDispatcher();
        this.mAppEventManger = new AppEventManager();
        BindEvent bindEvent = new BindEvent((Object)this, "dataSourceChanged", DataSourceChanged.class, 0);
        this.postAppEvent((AppEvent)bindEvent);
        this.mApp = (Application)pArgs.get("Application");
        Dc dc = (Dc)this.mBuilder.getNonVisualObject("OptionDc");
        dc.init((Dc)this, pArgs);
        dc = (Dc)this.mBuilder.getNonVisualObject("AboutDc");
        dc.init((Dc)this, pArgs);
        LoadDataRequest<FilteredTableModel> loadDataRequest = this.getCurrentRequest();
        Response response = this.mDispatcher.syncExecute(loadDataRequest);
        FilteredTableModel tableModel = response.isValid() ? (FilteredTableModel)response.getResult() : new CSVTableModel();
        this.mPc = (MainPc)this.mBuilder.getNonVisualObject("MainPc");
        HashMap<String, ? super Object> map = new HashMap<String, Object>(pArgs);
        map.put("tableModel", tableModel);
        this.mPc.init(this, map);
    }

    private LoadDataRequest<FilteredTableModel> getCurrentRequest() {
        AbstractRequest loadDataRequest;
        ValueModel firstRowIsHeaderModel = (ValueModel)this.mApp.getAppModel().get("FirstRowIsHeader");
        boolean firstRowIsHeader = firstRowIsHeaderModel.booleanValue();
        ValueModel csvSeparatorModel = (ValueModel)this.mApp.getAppModel().get("CSVSeparator");
        String csvSeparator = (String)csvSeparatorModel.getValue();
        ValueModel encodingModel = (ValueModel)this.mApp.getAppModel().get("EncodingSelection");
        String encoding = (String)encodingModel.getValue();
        ValueModel inputSelection = (ValueModel)this.mApp.getAppModel().get("InputSelection");
        String csvSource = (String)inputSelection.getValue();
        if (csvSource.equals("url")) {
            String urlName = this.mApp.getProperty("default.urlName", "");
            loadDataRequest = new LoadURLRequest(urlName, firstRowIsHeader, csvSeparator, encoding);
        } else if (csvSource.equals("tree")) {
            String treeName = this.mApp.getProperty("default.treeName", "");
            loadDataRequest = new LoadTreeRequest(treeName);
        } else {
            String fileName = this.mApp.getProperty("default.fileName", "src/test/resources/ca-500.csv");
            loadDataRequest = new LoadFileRequest(new File(fileName), firstRowIsHeader, csvSeparator, encoding);
        }
        return loadDataRequest;
    }

    public void openFile(File pFile) {
        this.mApp.setProperty("default.fileName", pFile.getPath());
        ValueModel inputSelection = (ValueModel)this.mApp.getAppModel().get("InputSelection");
        inputSelection.setValue((Object)"file");
        LoadDataRequest<FilteredTableModel> loadDataRequest = this.getCurrentRequest();
        loadDataRequest.setDispatchTarget(this, "loadResponse");
        this.mDispatcher.asyncDispatchInEDT(loadDataRequest);
    }

    public void openTree(File pFile) {
        this.mApp.setProperty("default.treeName", pFile.getPath());
        ValueModel inputSelection = (ValueModel)this.mApp.getAppModel().get("InputSelection");
        inputSelection.setValue((Object)"tree");
        LoadDataRequest<FilteredTableModel> loadDataRequest = this.getCurrentRequest();
        loadDataRequest.setDispatchTarget(this, "loadResponse");
        this.mDispatcher.asyncDispatchInEDT(loadDataRequest);
    }

    public void loadResponse(Response<FilteredTableModel> pResponse) {
        if (pResponse.isValid()) {
            FilteredTableModel newModel = (FilteredTableModel)pResponse.getResult();
            this.mPc.setModel(newModel);
        } else {
            this.mPc.showLoadError(pResponse);
        }
    }

    public void quit() {
        this.mApp.doStop();
    }

    public void dataSourceChanged(DataSourceChanged pDataSourceChanged) {
        LoadDataRequest<FilteredTableModel> loadDataRequest = this.getCurrentRequest();
        loadDataRequest.setDispatchTarget(this, "loadResponse");
        this.mDispatcher.asyncDispatchInEDT(loadDataRequest);
    }

    public void exeProgram(String pCommand) {
        try {
            Runtime.getRuntime().exec(pCommand);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

