package net.sf.cuf.csvview.browse;

import net.sf.cuf.csvview.util.CSVTableModel;
import net.sf.cuf.csvview.util.FilteredTableModel;
import net.sf.cuf.xfer.DefaultResponse;
import net.sf.cuf.xfer.Response;

import java.io.InputStream;
import java.net.URL;

/**
 * A LoadURLRequest creates a CSVTableModel.
 */
public class LoadURLRequest<T> extends AbstractLoadRequest<T> implements LoadDataRequest<T>
{
    /** URL as string, never null */
    private String      mURLName;

    /**
     * Creates a new LoadURLRequest, the CSV data is loaded in execute()
     * from the handed URL.
     * @param pURLName the URL we should take the CSV file from, must not be null
     * @param pFirstRowIsHeader true if the first row contains the header
     * @param pCSVSeparator "comma" separator, may be null
     * @param pEncoding the encoding, must not be nul
     * @throws IllegalArgumentException if pFile is null
     */
    public LoadURLRequest(final String pURLName, final boolean pFirstRowIsHeader, final String pCSVSeparator, final String pEncoding)
    {
        super(pCSVSeparator, pEncoding, pFirstRowIsHeader);
        if (pURLName==null)
        {
            throw new IllegalArgumentException("URL must not be null");
        }
        mURLName= pURLName;
    }

    /**
     * Generate a CSVTableModel with the URL given in the constructor.
     * @return a DefaultResponse with a FilteredTableModel as its result if
     *         everything worked, or an Exception as its error if we got problems
     */
    public Response<T> execute()
    {
        DefaultResponse<T> response= new DefaultResponse<>();
        try
        {
            URL         url  = new URL(mURLName);
            InputStream input= url.openStream();
            FilteredTableModel model= new CSVTableModel(input, mFirstRowIsHeader, mCSVSeparator, mEncoding);
            input.close();
            response.setResult(model);
        }
        catch (Exception e)
        {
            response.setError(e);
        }

        return response;
    }
}
