package net.sf.cuf.csvview.about;

import net.sf.cuf.csvview.Version;
import net.sf.cuf.ui.builder.IconCache;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw.Pc;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Timer;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.Map;

/**
 * The about panel has a small animation goody ;-).
 */
public class AboutPc implements Pc, ActionListener, SwingXMLBuilder.Backlink
{
    /** our mapping helper */
    private SwingXMLBuilder mBuilder;
    /** marker if we are during a fade */
    private boolean         mInFade;
    /** we count from 256 to 0, and then from 0 to 256 in STEP steps, fade level= counter-1 */
    private int             mCounter;
    /** either -STEP or +STEP */
    private int             mStep;
    /** our image filter */
    private AlphaFilter     mFilter;
    /** timer for the fade */
    private Timer           mTimer;
    /** the app icon, never null */
    private ImageIcon       mIcon1;
    /** my picture, never null  */
    private ImageIcon       mIcon2;
    /** either mIcon1 or mIcon2 */
    private ImageIcon       mIcon;

    /** delay for each step in msec */
    private static final int DELAY      = 100;
    /** upper fade level */
    private static final int MAX_COUNTER= 256;
    /** step size for the fade */
    private static final int STEP       = 16;

    /**
     * Create an presentation component for our about panel,
     * the rest of the construction work is done in init().
     */
    public AboutPc()
    {
        mInFade = false;
        mCounter= MAX_COUNTER;
        mStep   = -STEP;
        mTimer  = new Timer(DELAY, this);
        mFilter = new AlphaFilter();
    }

    /**
     * When a SwingXMLBuilder creates an object of ourselves, we want to
     * know that builder.
     * @param pBuilder the builder that created this object
     */
    public void setSwingXMLBuilder(final SwingXMLBuilder pBuilder)
    {
        mBuilder= pBuilder;
    }

    /**
     * This method initializes the widgets and connects the the label
     * to the timer start.
     * @param pDc our peer dialog component
     * @param pArgs the arguments
     */
    public void init(final Dc pDc, final Map<String, ? super Object> pArgs)
    {
        mIcon1= mBuilder.getIconCache().getIcon("AboutLogo", IconCache.ICON_MODIFIER_NORMAL);
        mIcon2= mBuilder.getIconCache().getIcon("jzeller",   IconCache.ICON_MODIFIER_NORMAL);
        mIcon = mIcon1;

        JLabel versionLabel = (JLabel) mBuilder.getComponentByName("Frame/AboutDialog/Panel/Version");
        StringBuilder versionText = new StringBuilder(versionLabel.getText());
        versionText.append(", Version ");
        versionText.append(Version.VERSION);
        versionText.append(" (");
        versionText.append(Version.DATE);
        versionText.append(" )");
        versionLabel.setText(versionText.toString());

        JLabel        jdkLabel= (JLabel) mBuilder.getComponentByName("Frame/AboutDialog/Panel/JDK");
        StringBuilder jdkText = new StringBuilder("Java VM from ");
        jdkText.append(System.getProperty("java.vendor"));
        jdkText.append(", Version ");
        jdkText.append(System.getProperty("java.version"));
        jdkLabel.setText(jdkText.toString());

        JLabel magicLabel= (JLabel) mBuilder.getComponentByName("Frame/AboutDialog/Panel/Magic");
        magicLabel.addMouseListener(new MouseAdapter()
        {
            public void mousePressed(final MouseEvent pMouseEvent)
            {
                if (mInFade)
                {
                    return;
                }

                mInFade = true;
                mCounter= MAX_COUNTER;
                mStep   = -STEP;
                mTimer.start();
            }
        });

    }

    /**
     * Invoked when an timer action occurs, we repaint (fade in/out) our image.
     * @param pEvent not used
     */
    public void actionPerformed(final ActionEvent pEvent)
    {
        JLabel magicLabel= (JLabel) mBuilder.getComponentByName("Frame/AboutDialog/Panel/Magic");
        mFilter.setLevel(mCounter-1);
        Image      image  = magicLabel.createImage(
                new FilteredImageSource(mIcon.getImage().getSource(), mFilter));
        ImageIcon  newIcon= new ImageIcon(image);
        magicLabel.setIcon(newIcon);

        mCounter+=mStep;
        if (mCounter<=0)
        {
            mCounter= +STEP;
            mStep   = +STEP;
            //noinspection ObjectEquality
            if (mIcon==mIcon1)
            {
                mIcon= mIcon2;
            }
            else
            {
                mIcon= mIcon1;
            }
        }

        if (mCounter>MAX_COUNTER)
        {
            mInFade= false;
            mTimer.stop();
        }
    }

    /**
     * Show an about dialog.
     */
    public void about()
    {
        // we want a modal dialog
        JDialog aboutDialog= (JDialog) mBuilder.getContainerByName("Frame/AboutDialog");
        aboutDialog.setModal(true);

        // set a default button
        JButton okButton= (JButton) mBuilder.getComponentByName("Frame/AboutDialog/Panel/OK");
        aboutDialog.getRootPane().setDefaultButton(okButton);

        // calculate size
        aboutDialog.pack();

        // center dialog with respect to its parent
        Rectangle parentBounds= aboutDialog.getParent().getBounds();
        int deltaX = (parentBounds.width  - aboutDialog.getBounds().width) / 2;
        int deltaY = (parentBounds.height - aboutDialog.getBounds().height) / 2;
        aboutDialog.setLocation(parentBounds.x + deltaX, parentBounds.y + deltaY);

        // make dialog visible
        aboutDialog.setVisible(true);
    }

    /**
     * Act on "OK" or "ESCAPE" in the about dialog.
     */
    public void aboutOK()
    {
        // reset icon
        JLabel magicLabel= (JLabel) mBuilder.getComponentByName("Frame/AboutDialog/Panel/Magic");
        mIcon= mIcon1;
        magicLabel.setIcon(mIcon);

        JDialog aboutDialog= (JDialog) mBuilder.getContainerByName("Frame/AboutDialog");
        aboutDialog.setVisible(false);
    }

    /**
     * fade helper, taken from http://www.rgagnon.com/javadetails/java-0249.html
     */
    private static class AlphaFilter extends RGBImageFilter
    {
        /** fade level, 0..255 */
        private int mLevel;

        /**
         * Create a new filter.
         */
        public AlphaFilter()
        {
            canFilterIndexColorModel = true;
        }

        /**
         * set filter level, 0..255
         * @param pLevel the level to set
         */
        public void setLevel(final int pLevel)
        {
            mLevel = pLevel;
        }

        public int filterRGB(final int pX, final int pY, final int pRGB)
        {
            return (pRGB &   0x00ffffff) | (mLevel * 0x01000000);
        }
    }
}
