package net.sf.cuf.csvview.browse;

import net.sf.cuf.csvview.util.CSVTableModel;
import net.sf.cuf.csvview.util.FilteredTableModel;
import net.sf.cuf.xfer.DefaultResponse;
import net.sf.cuf.xfer.Response;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

/**
 * A LoadFileRequest creates a CSVTableModel.
 */
public class LoadFileRequest<T> extends AbstractLoadRequest<T> implements LoadDataRequest<T>
{
    /** file we should load the data from, never null */
    private File        mFile;

    /**
     * Creates a new LoadFileRequest, the CSV data is loaded in execute() from
     * the handed file.
     * @param pFile file to load the data from
     * @param pFirstRowIsHeader true if the first row contains the header
     * @param pCSVSeparator "comma" separator, may be null
     * @param pEncoding the encoding, must not be nul
     * @throws IllegalArgumentException if pFile is null
     */
    public LoadFileRequest(final File pFile, final boolean pFirstRowIsHeader, final String pCSVSeparator, final String pEncoding)
    {
        super(pCSVSeparator, pEncoding, pFirstRowIsHeader);
        if (pFile==null)
        {
            throw new IllegalArgumentException("file must not be null");
        }
        mFile= pFile;
    }

    /**
     * Generate a CSVTableModel with the file given in the constructor.
     * @return a DefaultResponse with a FilteredTableModel as its result if
     *         everything worked, or an Exception as its error if we got problems
     */
    public Response<T> execute()
    {
        DefaultResponse<T> response= new DefaultResponse<>();
        try
        {
            InputStream   input= new FileInputStream(mFile);

            FilteredTableModel model= new CSVTableModel(input, mFirstRowIsHeader, mCSVSeparator, mEncoding);
            input.close();
            response.setResult(model);
        }
        catch (Exception e)
        {
            response.setError(e);
        }

        return response;
    }
}
