/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.xfer;

import java.lang.reflect.InvocationTargetException;
import net.sf.cuf.xfer.Dispatch;
import net.sf.cuf.xfer.DispatchTarget;
import net.sf.cuf.xfer.Request;
import net.sf.cuf.xfer.RequestDelegate;
import net.sf.cuf.xfer.Response;

public abstract class AbstractDispatcher
implements Dispatch {
    @Override
    public <T> void asyncDispatch(final Request<T> pRequest) {
        Thread load = new Thread(){

            @Override
            public void run() {
                AbstractDispatcher.this.syncDispatch(pRequest);
            }
        };
        load.start();
    }

    @Override
    public <T> void asyncDispatchInEDT(Request<T> pRequest) {
        Thread load = new Thread(new DispatchRunnable<T>(pRequest));
        load.start();
    }

    @Override
    public <T> Response<T> syncExecute(Request<T> pRequest) {
        RequestDelegate<T> delegate = pRequest.getDelegate();
        Response<T> response = delegate != null ? delegate.execute(pRequest) : pRequest.execute();
        return response;
    }

    @Override
    public <T> void syncDispatch(Request<T> pRequest) {
        DispatchTarget target = pRequest.getDispatchTarget();
        Response<T> response = this.syncExecute(pRequest);
        this.syncDispatch(target, response);
    }

    private <T> void syncDispatch(DispatchTarget pTarget, Response<T> pResponse) {
        try {
            Object[] args = new Object[]{pResponse};
            pTarget.getTargetMethod().invoke(pTarget.getTargetObject(), args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new IllegalArgumentException(cause != null ? cause.getMessage() : e.getMessage());
        }
    }

    protected abstract void doDispatch(Runnable var1);

    protected class DispatchRunnable<T>
    implements Runnable {
        private final Request<T> mRequest;
        private final DispatchTarget mTarget;
        private Response mResponse;

        public DispatchRunnable(Request<T> pRequest) {
            this.mRequest = pRequest;
            this.mTarget = pRequest.getDispatchTarget();
            if (this.mTarget == null) {
                throw new IllegalArgumentException("target must not be null");
            }
        }

        @Override
        public void run() {
            if (this.mResponse != null) {
                AbstractDispatcher.this.syncDispatch(this.mTarget, this.mResponse);
            } else {
                this.mResponse = AbstractDispatcher.this.syncExecute(this.mRequest);
                if (this.mResponse != null) {
                    AbstractDispatcher.this.doDispatch(this);
                }
            }
        }
    }
}

