/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.table;

import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import net.sf.cuf.ui.table.TableMap;
import net.sf.cuf.ui.table.TableSortInfo;

public class TableSorter
extends TableMap {
    private int[] mIndexes;
    private TableSortInfo mSortingColumns = new TableSortInfo();

    public TableSorter(TableModel pModel) {
        this.setModel(pModel);
    }

    @Override
    public void setModel(TableModel pModel) {
        super.setModel(pModel);
        this.mIndexes = new int[pModel.getRowCount()];
        for (int row = 0; row < this.mIndexes.length; ++row) {
            this.mIndexes[row] = row;
        }
    }

    public int getModelRow(int pRow) {
        return this.mIndexes[pRow];
    }

    public int getViewRow(int pRow) {
        for (int i = 0; i < this.mIndexes.length; ++i) {
            if (this.mIndexes[i] != pRow) continue;
            return i;
        }
        return -1;
    }

    public boolean isSorted(int pColumn) {
        return this.mSortingColumns.isSorted(pColumn);
    }

    @Override
    public void tableChanged(TableModelEvent pEvent) {
        int type = pEvent.getType();
        int firstRow = pEvent.getFirstRow();
        int lastRow = pEvent.getLastRow();
        int column = pEvent.getColumn();
        if (type == 1 || type == -1) {
            if (firstRow != lastRow) {
                throw new IllegalArgumentException("firstRow and lastRow must be equal for INSERT or DELETE");
            }
            this.reallocateIndexesForInsertDelete(type, firstRow);
        }
        if (type == 0) {
            if (this.isSorted(column)) {
                this.mSortingColumns.clear();
            }
            if (column == -1) {
                this.reallocateIndexesForUpdate();
            }
            this.sort();
        }
        super.tableChanged(pEvent);
    }

    @Override
    public Object getValueAt(int pRow, int pColumn) {
        this.checkModel();
        return this.mModel.getValueAt(this.mIndexes[pRow], pColumn);
    }

    @Override
    public void setValueAt(Object pValue, int pRow, int pColumn) {
        this.checkModel();
        this.mModel.setValueAt(pValue, this.mIndexes[pRow], pColumn);
    }

    public void sortByColumn(int pColumn) {
        this.sortByColumn(pColumn, true);
    }

    public void sortByColumn(int pColumn, boolean pAscending) {
        this.mSortingColumns.sortByColumn(pColumn, pAscending);
        this.sort();
        this.fireTableDataChanged();
    }

    public void dropSorting() {
        this.mSortingColumns.clear();
        this.fireTableDataChanged();
    }

    public void resetColumns() {
        this.mSortingColumns.clear();
        this.tableChanged(new TableModelEvent(this));
    }

    public TableSortInfo getSortInfo() {
        return this.mSortingColumns.cloneImmutable();
    }

    private void checkModel() {
        if (this.mIndexes.length != this.mModel.getRowCount()) {
            throw new IllegalStateException("Sorter not informed of a change in model.");
        }
    }

    protected void sort() {
        this.checkModel();
        this.shuttlesort((int[])this.mIndexes.clone(), this.mIndexes, 0, this.mIndexes.length);
    }

    private void shuttlesort(int[] pFrom, int[] pTo, int pLow, int pHigh) {
        if (pHigh - pLow < 2) {
            return;
        }
        int middle = (pLow + pHigh) / 2;
        this.shuttlesort(pTo, pFrom, pLow, middle);
        this.shuttlesort(pTo, pFrom, middle, pHigh);
        int p = pLow;
        int q = middle;
        if (pHigh - pLow >= 4 && this.compare(pFrom[middle - 1], pFrom[middle]) <= 0) {
            System.arraycopy(pFrom, pLow, pTo, pLow, pHigh - pLow);
            return;
        }
        for (int i = pLow; i < pHigh; ++i) {
            pTo[i] = q >= pHigh || p < middle && this.compare(pFrom[p], pFrom[q]) <= 0 ? pFrom[p++] : pFrom[q++];
        }
    }

    protected int compareRowsByColumn(int pRow1, int pRow2, int pColumn) {
        Object o1 = this.mModel.getValueAt(pRow1, pColumn);
        Object o2 = this.mModel.getValueAt(pRow2, pColumn);
        if (o1 == null || o2 == null) {
            return o1 != null ? 1 : (o2 != null ? -1 : 0);
        }
        if (o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        String s1 = o1.toString();
        String s2 = o2.toString();
        return s1.compareTo(s2);
    }

    protected int compare(int pRow1, int pRow2) {
        for (int level = 0; level < this.mSortingColumns.size(); ++level) {
            int result = this.compareRowsByColumn(pRow1, pRow2, this.mSortingColumns.getColumn(level));
            if (result == 0) continue;
            return this.mSortingColumns.isAscending(level) ? result : -result;
        }
        return 0;
    }

    private void reallocateIndexesForInsertDelete(int pType, int pRow) {
        int[] newindexes;
        int direction = 0;
        if (pType == -1) {
            direction = -1;
        }
        if (pType == 1) {
            direction = 1;
        }
        if ((newindexes = new int[this.mIndexes.length + direction]).length > 0) {
            newindexes[newindexes.length - 1] = pRow;
        }
        int adjust = 0;
        for (int row = 0; row < this.mIndexes.length; ++row) {
            if (this.mIndexes[row] == pRow) {
                adjust = direction;
                if (adjust <= 0) continue;
                newindexes[row] = pRow;
                newindexes[row + adjust] = this.mIndexes[row] + direction;
                continue;
            }
            if (row + adjust < 0) continue;
            newindexes[row + adjust] = this.mIndexes[row] + (this.mIndexes[row] > pRow ? direction : 0);
        }
        this.mIndexes = newindexes;
    }

    private void reallocateIndexesForUpdate() {
        int[] newindexes = this.mModel.getRowCount() == this.mIndexes.length ? this.mIndexes : new int[this.mModel.getRowCount()];
        for (int row = 0; row < newindexes.length; ++row) {
            newindexes[row] = row;
        }
        this.mIndexes = newindexes;
    }
}

