/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.table;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.sf.cuf.ui.table.SortingTable;
import net.sf.cuf.ui.table.TableSortInfo;
import net.sf.cuf.ui.table.TableSorter;

public class TableProperties {
    private static final String TABLE = "TABLE";
    private static final String WIDTH_KEY = ".WIDTH.";
    private static final String INDEX_KEY = ".INDEX.";
    private static final String ORDER_KEY = ".ORDER_";
    private static final String ORDER_SUF = ".";
    private static final String ASC_VAL = "ASCENDING";
    private static final String DESC_VAL = "DESCENDING";

    private TableProperties() {
    }

    public static void load(JTable pTable, Properties pProperties, String pPrefix) {
        int modelIndex;
        if (pTable == null) {
            throw new IllegalArgumentException("pTable must not be null");
        }
        if (pProperties == null) {
            throw new IllegalArgumentException("pProperties must not be null");
        }
        String prefix = pPrefix == null ? pTable.getName() : pPrefix;
        prefix = prefix == null ? TABLE : prefix;
        TableModel model = pTable.getModel();
        TableColumnModel tableColumnModel = pTable.getColumnModel();
        boolean dataCorrupt = false;
        for (int modelIndex2 = 0; modelIndex2 < model.getColumnCount(); ++modelIndex2) {
            int columnWidth;
            String key = prefix + WIDTH_KEY + modelIndex2;
            String columnWidthString = pProperties.getProperty(key);
            try {
                columnWidth = Integer.parseInt(columnWidthString);
            }
            catch (NumberFormatException ex) {
                dataCorrupt = true;
                break;
            }
            int viewIndex = pTable.convertColumnIndexToView(modelIndex2);
            tableColumnModel.getColumn(viewIndex).setPreferredWidth(columnWidth);
        }
        int[] userPosition = new int[model.getColumnCount()];
        for (int i = 0; i < userPosition.length; ++i) {
            userPosition[i] = -1;
        }
        int n = userPosition.length;
        for (int modelIndex3 = 0; modelIndex3 < n; ++modelIndex3) {
            String key = prefix + INDEX_KEY + modelIndex3;
            String viewIndexString = pProperties.getProperty(key);
            if (viewIndexString == null) continue;
            try {
                int viewIndex = Integer.parseInt(viewIndexString);
                if (viewIndex >= n) {
                    dataCorrupt = true;
                    break;
                }
                if (viewIndex < 0) continue;
                userPosition[modelIndex3] = viewIndex;
                continue;
            }
            catch (NumberFormatException e) {
                dataCorrupt = true;
                break;
            }
        }
        if (dataCorrupt) {
            System.err.println("table properties corrupt");
            return;
        }
        SortingTable sortingTable = null;
        if (pTable instanceof SortingTable) {
            sortingTable = (SortingTable)pTable;
        }
        HashSet<Integer> usedIndexes = new HashSet<Integer>(userPosition.length);
        for (modelIndex = 0; modelIndex < userPosition.length; ++modelIndex) {
            if (userPosition[modelIndex] >= userPosition.length || userPosition[modelIndex] < -1) {
                userPosition[modelIndex] = -1;
                continue;
            }
            if (userPosition[modelIndex] == -1) continue;
            Integer userPositionInteger = userPosition[modelIndex];
            if (usedIndexes.contains(userPositionInteger)) {
                userPosition[modelIndex] = -1;
                continue;
            }
            usedIndexes.add(userPositionInteger);
        }
        TableProperties.moveTableColumns(pTable, userPosition);
        if (sortingTable != null) {
            for (modelIndex = 0; modelIndex < userPosition.length; ++modelIndex) {
                if (userPosition[modelIndex] >= 0) continue;
                sortingTable.setColumnVisible(modelIndex, false);
            }
        }
        if (model instanceof TableSorter) {
            TableSorter sorter = (TableSorter)model;
            for (int prio = 0; prio < sorter.getColumnCount(); ++prio) {
                for (int column = 0; column < sorter.getColumnCount(); ++column) {
                    String key = prefix + ORDER_KEY + prio + ORDER_SUF + column;
                    String sortOrder = pProperties.getProperty(key);
                    if (sortOrder == null) continue;
                    String ascendingVal = sortOrder;
                    sorter.sortByColumn(column, ascendingVal.equalsIgnoreCase(ASC_VAL));
                }
            }
        }
    }

    public static void store(JTable pTable, Properties pProperties, String pPrefix) {
        if (pTable == null) {
            throw new IllegalArgumentException("pTable must not be null");
        }
        if (pProperties == null) {
            throw new IllegalArgumentException("pProperties must not be null");
        }
        String prefix = pPrefix == null ? pTable.getName() : pPrefix;
        prefix = prefix == null ? TABLE : prefix;
        Iterator<Object> it = pProperties.keySet().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o != null && !o.toString().startsWith(prefix)) continue;
            it.remove();
        }
        TableModel model = pTable.getModel();
        TableColumnModel tableColumnModel = pTable.getColumnModel();
        for (int modelIndex = 0; modelIndex < model.getColumnCount(); ++modelIndex) {
            int viewIndex = pTable.convertColumnIndexToView(modelIndex);
            pProperties.put(prefix + INDEX_KEY + modelIndex, String.valueOf(viewIndex));
            if (viewIndex >= 0) {
                pProperties.put(prefix + WIDTH_KEY + modelIndex, String.valueOf(tableColumnModel.getColumn(viewIndex).getWidth()));
                continue;
            }
            if (!(pTable instanceof SortingTable)) continue;
            pProperties.put(prefix + WIDTH_KEY + modelIndex, String.valueOf(((SortingTable)pTable).getInvisibleColumn(modelIndex).getWidth()));
        }
        if (model instanceof TableSorter) {
            TableSortInfo sortedColumns = ((TableSorter)model).getSortInfo();
            for (int prio = 0; prio < sortedColumns.size(); ++prio) {
                String orderVal = sortedColumns.isAscending(prio) ? ASC_VAL : DESC_VAL;
                pProperties.put(prefix + ORDER_KEY + prio + ORDER_SUF + sortedColumns.getColumn(prio), orderVal);
            }
        }
    }

    private static void moveTableColumns(JTable pTable, int[] pUserPosition) {
        int[] actualPosition = new int[pUserPosition.length];
        boolean done = false;
        block0: while (!done) {
            int modelIndex;
            for (modelIndex = 0; modelIndex < actualPosition.length; ++modelIndex) {
                actualPosition[modelIndex] = pTable.convertColumnIndexToView(modelIndex);
            }
            done = true;
            for (modelIndex = 0; modelIndex < pUserPosition.length; ++modelIndex) {
                if (pUserPosition[modelIndex] <= 0 || actualPosition[modelIndex] == pUserPosition[modelIndex]) continue;
                pTable.moveColumn(actualPosition[modelIndex], pUserPosition[modelIndex]);
                done = false;
                continue block0;
            }
        }
    }
}

