/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.table;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.JTable;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.sf.cuf.ui.table.ColumnVisibilityChangeEvent;
import net.sf.cuf.ui.table.ColumnVisibilityChangeListener;
import net.sf.cuf.ui.table.ColumnVisibilitySupport;
import net.sf.cuf.ui.table.TableHeaderRenderer;
import net.sf.cuf.ui.table.TableSortInfo;
import net.sf.cuf.ui.table.TableSorter;

public class SortingTable
extends JTable
implements MouseListener,
ColumnVisibilityChangeListener {
    protected TableSorter mSorter = null;
    protected ColumnVisibilitySupport mColumnVisibilitySupport = new ColumnVisibilitySupport(this);

    public SortingTable() {
        this(null);
    }

    public SortingTable(TableModel pTableModel) {
        this.mColumnVisibilitySupport.addColumnVisibilityChangeListener(this);
        if (pTableModel == null) {
            pTableModel = new DefaultTableModel();
        }
        this.setModel(pTableModel);
        this.initialize();
    }

    protected void initialize() {
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            this.columnModel.getColumn(i).setHeaderRenderer(this.getTableHeaderRenderer());
        }
        this.tableHeader.addMouseListener(this);
    }

    protected TableHeaderRenderer getTableHeaderRenderer() {
        return new TableHeaderRenderer();
    }

    protected void redrawTableHeaders() {
        TableSortInfo sortedColumns = this.mSorter.getSortInfo();
        for (int i = 0; i < this.columnModel.getColumnCount(); ++i) {
            TableHeaderRenderer thr = (TableHeaderRenderer)this.columnModel.getColumn(i).getHeaderRenderer();
            thr.setDirection(0);
            int modelIndex = this.convertColumnIndexToModel(i);
            int entryIndex = sortedColumns.find(modelIndex);
            if (entryIndex < 0) continue;
            thr.setDirection(sortedColumns.isAscending(entryIndex) ? 1 : -1);
        }
        if (this.tableHeader != null) {
            this.tableHeader.resizeAndRepaint();
        }
    }

    @Override
    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        if (this.mColumnVisibilitySupport != null) {
            this.mColumnVisibilitySupport.clearInvisibleColumns();
        }
    }

    @Override
    public void columnShown(ColumnVisibilityChangeEvent pEvent) {
    }

    @Override
    public void columnHidden(ColumnVisibilityChangeEvent pEvent) {
        int modelIndex = pEvent.getColumn().getModelIndex();
        if (this.mSorter.isSorted(modelIndex)) {
            this.mSorter.dropSorting();
        }
    }

    public boolean isColumnVisible(int pModelIndex) {
        return this.mColumnVisibilitySupport.isColumnVisible(pModelIndex);
    }

    public void setColumnVisible(int pModelIndex, boolean pVisible) {
        this.mColumnVisibilitySupport.setColumnVisible(pModelIndex, pVisible);
    }

    public boolean[] getColumnsVisible() {
        return this.mColumnVisibilitySupport.getColumnsVisible();
    }

    public void setColumnsVisible(boolean[] pVisible) {
        this.mColumnVisibilitySupport.setColumnsVisible(pVisible);
    }

    public void setAllColumnsVisible() {
        this.mColumnVisibilitySupport.setAllColumnsVisible();
    }

    public boolean isAllColumnsVisible() {
        return this.mColumnVisibilitySupport.isAllColumnsVisible();
    }

    TableColumn getInvisibleColumn(int pModelIndex) {
        return this.mColumnVisibilitySupport.getInvisibleColumn(pModelIndex);
    }

    @Override
    public void addColumn(TableColumn pColumn) {
        if (!(pColumn.getHeaderRenderer() instanceof TableHeaderRenderer)) {
            pColumn.setHeaderRenderer(this.getTableHeaderRenderer());
        }
        super.addColumn(pColumn);
    }

    @Override
    public void columnAdded(TableColumnModelEvent pEvent) {
        this.redrawTableHeaders();
        super.columnAdded(pEvent);
    }

    @Override
    public void setModel(TableModel pModel) {
        TableSorter lModel = pModel instanceof TableSorter ? (TableSorter)pModel : this.wrapModel(pModel);
        this.mSorter = lModel;
        super.setModel(lModel);
    }

    protected TableSorter wrapModel(TableModel pTableModel) {
        return new TableSorter(pTableModel);
    }

    @Override
    public void tableChanged(TableModelEvent pEvent) {
        if (pEvent.getType() == 0 && pEvent.getColumn() == -1) {
            this.redrawTableHeaders();
        }
        super.tableChanged(pEvent);
    }

    @Override
    public void mouseClicked(MouseEvent pEvent) {
        if ((pEvent.getModifiers() & 4) != 0) {
            return;
        }
        if (this.getTableHeader().getCursor().getType() != 0) {
            return;
        }
        TableCellEditor ce = this.getCellEditor();
        if (ce == null || ce.stopCellEditing()) {
            int viewIndex = this.columnModel.getColumnIndexAtX(pEvent.getX());
            int column = this.convertColumnIndexToModel(viewIndex);
            if (pEvent.getClickCount() == 1 && column != -1) {
                boolean reset = (pEvent.getModifiers() & 2) == 0;
                boolean ascending = (pEvent.getModifiers() & 1) == 0;
                Point aPoint = new Point(pEvent.getX(), 1);
                Rectangle columnRect = new Rectangle(0, 0, 0, 3);
                Enumeration<TableColumn> enumeration = this.columnModel.getColumns();
                while (enumeration.hasMoreElements()) {
                    TableColumn aColumn = enumeration.nextElement();
                    columnRect.width = aColumn.getWidth();
                    if (columnRect.contains(aPoint)) break;
                    columnRect.x += columnRect.width;
                }
                TableHeaderRenderer thr = (TableHeaderRenderer)this.columnModel.getColumn(viewIndex).getHeaderRenderer();
                switch (thr.hitButton(pEvent.getX() - columnRect.x, pEvent.getY())) {
                    case 1: {
                        ascending = true;
                        break;
                    }
                    case -1: {
                        ascending = false;
                    }
                }
                if (reset) {
                    this.mSorter.resetColumns();
                }
                this.mSorter.sortByColumn(column, ascending);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent pEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent pEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent pEvent) {
    }

    @Override
    public void mousePressed(MouseEvent pEvent) {
    }
}

