/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class GuiUtilities {
    public static final int POPUP_ADJUSTMENT_STRATEGY_MOVE = 1;
    public static final int POPUP_ADJUSTMENT_STRATEGY_FLIP = 2;
    private static GuiUtilities sInstance = null;
    protected int mPopupAdjustmentStrategy = 1;

    public static GuiUtilities getDefault() {
        if (sInstance == null) {
            sInstance = new GuiUtilities();
        }
        return sInstance;
    }

    protected static void setDefault(GuiUtilities pInstance) {
        sInstance = pInstance;
    }

    public int getPopupAdjustmentStrategy() {
        return this.mPopupAdjustmentStrategy;
    }

    public void setPopupAdjustmentStrategy(int pStrategy) {
        if (pStrategy != 1 && pStrategy != 2) {
            throw new IllegalArgumentException("strategy must be a valid value");
        }
        this.mPopupAdjustmentStrategy = pStrategy;
    }

    public Point adjustPopupPosition(JPopupMenu popup, Component pInvoker, Point pPosition) {
        Point p = (Point)pPosition.clone();
        SwingUtilities.convertPointToScreen(p, pInvoker);
        Rectangle screen = this.determineVisibleScreenArea();
        Dimension popupsize = popup.getLayout().preferredLayoutSize(popup);
        if (this.mPopupAdjustmentStrategy == 1) {
            if (p.x + popupsize.width > screen.x + screen.width) {
                p.x = screen.x + screen.width - popupsize.width;
            }
            if (p.x < screen.x) {
                p.x = screen.x;
            }
            if (p.y + popupsize.height > screen.y + screen.height) {
                p.y = screen.y + screen.height - popupsize.height;
            }
            if (p.y < screen.y) {
                p.y = screen.y;
            }
        } else {
            if (p.x < screen.x) {
                p.x = screen.x;
            }
            if (p.y < screen.y) {
                p.y = screen.y;
            }
            if (p.x + popupsize.width > screen.x + screen.width) {
                p.x -= popupsize.width;
            }
            if (p.y + popupsize.height > screen.y + screen.height) {
                p.y -= popupsize.height;
            }
        }
        SwingUtilities.convertPointFromScreen(p, pInvoker);
        return p;
    }

    public void showPopupAdjusted(JPopupMenu popup, Component pInvoker, Point pPosition) {
        Point pos = this.adjustPopupPosition(popup, pInvoker, pPosition);
        popup.show(pInvoker, pos.x, pos.y);
    }

    protected Rectangle determineVisibleScreenArea() {
        return new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
    }
}

