/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class AutoCompletion
extends PlainDocument {
    private JComboBox mComboBox;
    private ComboBoxModel mModel;
    private JTextComponent mEditor;
    private boolean mSelecting;
    private boolean mHidePopupOnFocusLoss;
    private boolean mHitBackspace;
    private boolean mHitBackspaceOnSelection;
    private KeyListener mEditorKeyListener;
    private FocusListener mEditorFocusListener;

    public AutoCompletion(final JComboBox pComboBox) {
        this.mComboBox = pComboBox;
        this.mModel = pComboBox.getModel();
        pComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pEvent) {
                if (!AutoCompletion.this.mSelecting) {
                    AutoCompletion.this.highlightCompletedText(0);
                }
            }
        });
        pComboBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pEvent) {
                if ("editor".equals(pEvent.getPropertyName())) {
                    AutoCompletion.this.configureEditor((ComboBoxEditor)pEvent.getNewValue());
                }
                if ("model".equals(pEvent.getPropertyName())) {
                    AutoCompletion.this.mModel = (ComboBoxModel)pEvent.getNewValue();
                }
            }
        });
        this.mEditorKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent pEvent) {
                if (pComboBox.isDisplayable()) {
                    pComboBox.setPopupVisible(true);
                }
                AutoCompletion.this.mHitBackspace = false;
                switch (pEvent.getKeyCode()) {
                    case 8: {
                        AutoCompletion.this.mHitBackspace = true;
                        AutoCompletion.this.mHitBackspaceOnSelection = AutoCompletion.this.mEditor.getSelectionStart() != AutoCompletion.this.mEditor.getSelectionEnd();
                        break;
                    }
                    case 127: {
                        pEvent.consume();
                        pComboBox.getToolkit().beep();
                    }
                }
            }
        };
        this.mHidePopupOnFocusLoss = System.getProperty("java.version").startsWith("1.5");
        this.mEditorFocusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent pEvent) {
                AutoCompletion.this.highlightCompletedText(0);
            }

            @Override
            public void focusLost(FocusEvent pEvent) {
                if (AutoCompletion.this.mHidePopupOnFocusLoss) {
                    pComboBox.setPopupVisible(false);
                }
            }
        };
        this.configureEditor(pComboBox.getEditor());
        Object selected = pComboBox.getSelectedItem();
        if (selected != null) {
            this.setText(selected.toString());
        }
        this.highlightCompletedText(0);
    }

    public static void enable(JComboBox pComboBox) {
        pComboBox.setEditable(true);
        new AutoCompletion(pComboBox);
    }

    void configureEditor(ComboBoxEditor pNewEditor) {
        if (this.mEditor != null) {
            this.mEditor.removeKeyListener(this.mEditorKeyListener);
            this.mEditor.removeFocusListener(this.mEditorFocusListener);
        }
        if (pNewEditor != null) {
            this.mEditor = (JTextComponent)pNewEditor.getEditorComponent();
            this.mEditor.addKeyListener(this.mEditorKeyListener);
            this.mEditor.addFocusListener(this.mEditorFocusListener);
            this.mEditor.setDocument(this);
        }
    }

    @Override
    public void remove(int pOffs, int pLen) throws BadLocationException {
        if (this.mSelecting) {
            return;
        }
        if (this.mHitBackspace) {
            if (pOffs > 0) {
                if (this.mHitBackspaceOnSelection) {
                    --pOffs;
                }
            } else {
                this.mComboBox.getToolkit().beep();
            }
            this.highlightCompletedText(pOffs);
        } else {
            super.remove(pOffs, pLen);
        }
    }

    @Override
    public void insertString(int pOffs, String pStr, AttributeSet pAttributeSet) throws BadLocationException {
        if (this.mSelecting) {
            return;
        }
        super.insertString(pOffs, pStr, pAttributeSet);
        Object item = this.lookupItem(this.getText(0, this.getLength()));
        if (item != null) {
            this.setSelectedItem(item);
        } else {
            item = this.mComboBox.getSelectedItem();
            pOffs -= pStr.length();
            this.mComboBox.getToolkit().beep();
        }
        this.setText(item.toString());
        this.highlightCompletedText(pOffs + pStr.length());
    }

    private void setText(String pText) {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, pText, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void highlightCompletedText(int pStart) {
        this.mEditor.setCaretPosition(this.getLength());
        this.mEditor.moveCaretPosition(pStart);
    }

    private void setSelectedItem(Object pItem) {
        this.mSelecting = true;
        this.mModel.setSelectedItem(pItem);
        this.mSelecting = false;
    }

    private Object lookupItem(String pPattern) {
        Object selectedItem = this.mModel.getSelectedItem();
        if (selectedItem != null && this.startsWithIgnoreCase(selectedItem.toString(), pPattern)) {
            return selectedItem;
        }
        int n = this.mModel.getSize();
        for (int i = 0; i < n; ++i) {
            Object currentItem = this.mModel.getElementAt(i);
            if (currentItem == null || !this.startsWithIgnoreCase(currentItem.toString(), pPattern)) continue;
            return currentItem;
        }
        return null;
    }

    private boolean startsWithIgnoreCase(String pStr1, String pStr2) {
        return pStr1.toUpperCase().startsWith(pStr2.toUpperCase());
    }

    private static void createAndShowGUI() {
        JComboBox<Object> comboBox = new JComboBox<Object>(new Object[]{"Ester", "Jordi", "Jordina", "Jorge", "Sergi"});
        AutoCompletion.enable(comboBox);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(comboBox);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] pArgs) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoCompletion.createAndShowGUI();
            }
        });
    }
}

