/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.cuf.model.ValueModel;

public class RadioButtonAdapter
implements ActionListener,
ChangeListener {
    private ValueModel mSelectionHolder;
    private List<ButtonModel> mButtonModels;
    private boolean mInCallback;

    public RadioButtonAdapter(ValueModel pSelectionHolder, List<ButtonModel> pButtonModels) {
        if (pSelectionHolder == null) {
            throw new IllegalArgumentException("selection holder must not be null");
        }
        if (pButtonModels == null) {
            throw new IllegalArgumentException("button model list must not be null");
        }
        this.mSelectionHolder = pSelectionHolder;
        this.mButtonModels = pButtonModels;
        this.mInCallback = false;
        int n = this.mButtonModels.size();
        for (int i = 0; i < n; ++i) {
            ButtonModel buttonModel = this.mButtonModels.get(i);
            buttonModel.addActionListener(this);
        }
        this.mSelectionHolder.addChangeListener(this);
        this.adjustRadiobuttons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent pEvent) {
        if (this.mInCallback) {
            return;
        }
        ButtonModel model = (ButtonModel)pEvent.getSource();
        Integer index = this.mButtonModels.indexOf(model);
        try {
            this.mInCallback = true;
            this.mSelectionHolder.setValue(index);
        }
        finally {
            this.mInCallback = false;
        }
    }

    @Override
    public void stateChanged(ChangeEvent pEvent) {
        if (this.mInCallback) {
            return;
        }
        this.adjustRadiobuttons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustRadiobuttons() {
        Integer index = (Integer)this.mSelectionHolder.getValue();
        try {
            this.mInCallback = true;
            if (index == null) {
                int n = this.mButtonModels.size();
                for (int i = 0; i < n; ++i) {
                    ButtonModel model = this.mButtonModels.get(i);
                    model.setSelected(false);
                }
            } else {
                ButtonModel model = this.mButtonModels.get(index);
                model.setSelected(true);
            }
        }
        finally {
            this.mInCallback = false;
        }
    }
}

