/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.sf.cuf.model.DelegateAccess;
import net.sf.cuf.model.MultiSelectionInList;
import net.sf.cuf.model.ui.ColumnAlignmentRenderer;
import net.sf.cuf.model.ui.IndexConverter;
import net.sf.cuf.model.ui.ListTableMapper;
import net.sf.cuf.model.ui.ListTableMapperBase;
import net.sf.cuf.model.ui.NewTableSorter;
import net.sf.cuf.ui.builder.SwingXMLBuilder;

public class MultiSelectionTableModelAdapter
implements TableModel,
ListSelectionListener {
    private JTable mTable;
    protected MultiSelectionInList mMultiSelectionInList;
    private EventListenerList mListenerList;
    private boolean mInSelectionChange;
    private IndexConverter mIndexConverter;
    private List<ListTableMapper.Mapping> mColumnMapping = Collections.emptyList();
    private static final IndexConverter IDENTITY_CONVERTER = new ListTableMapperBase.IdentityIndexConverter();
    private static final Class<?>[] NO_PARAMS = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];

    public MultiSelectionTableModelAdapter(JTable pTable, MultiSelectionInList pValueModel, List<ListTableMapper.Mapping> pMapping, boolean pSortable) {
        this(pTable, pValueModel, pMapping, pSortable, -1);
    }

    public MultiSelectionTableModelAdapter(JTable pTable, MultiSelectionInList pValueModel, List<ListTableMapper.Mapping> pMapping, boolean pSortable, int pColumnForInitialSorting) {
        this.init(pTable, pValueModel);
        this.setColumnMapping(pTable, pMapping, pSortable, pColumnForInitialSorting);
    }

    protected void init(JTable pTable, MultiSelectionInList pValueModel) {
        if (pTable == null) {
            throw new IllegalArgumentException("the table must not be null");
        }
        if (pValueModel == null) {
            throw new IllegalArgumentException("the value model must not be null");
        }
        this.mTable = pTable;
        this.mMultiSelectionInList = pValueModel;
        this.mListenerList = new EventListenerList();
        this.mInSelectionChange = false;
        this.mIndexConverter = IDENTITY_CONVERTER;
        this.mMultiSelectionInList.onChangeSend(this, "vmDataChanged");
        this.mMultiSelectionInList.getSelectedIndexSetValueModel().onChangeSend(this, "vmSelectionChanged");
        pTable.setModel(this);
        pTable.getSelectionModel().addListSelectionListener(this);
    }

    private void setColumnMapping(JTable pTable, List<ListTableMapper.Mapping> pMapping, boolean pSortable, int pColumnForInitialSorting) {
        if (pMapping == null) {
            throw new IllegalArgumentException("mapping must not be null");
        }
        ArrayList<ListTableMapper.Mapping> columnMapping = new ArrayList<ListTableMapper.Mapping>(pMapping.size());
        int n = pMapping.size();
        for (int i = 0; i < n; ++i) {
            ListTableMapper.Mapping mapping = pMapping.get(i);
            ListTableMapper.Mapping myMapping = new ListTableMapper.Mapping(mapping);
            columnMapping.add(myMapping);
        }
        this.mColumnMapping = columnMapping;
        TableModelEvent e = new TableModelEvent(this, -1);
        this.fireTableChanged(e);
        if (pSortable) {
            NewTableSorter sorter = new NewTableSorter(pTable.getModel());
            sorter.setTableHeader(pTable.getTableHeader());
            pTable.setModel(sorter);
            this.setIndexConverter(sorter);
            int n2 = pMapping.size();
            for (int i = 0; i < n2; ++i) {
                ListTableMapper.Mapping mapping = pMapping.get(i);
                if (mapping.getComparatorClass() == null) continue;
                try {
                    Comparator myComparator = (Comparator)mapping.getComparatorClass().getConstructor(NO_PARAMS).newInstance(NO_ARGS);
                    sorter.setColumnComparator(mapping.getColumnClass(), myComparator);
                    continue;
                }
                catch (Exception e1) {
                    throw SwingXMLBuilder.createException("could not instantiate ComparatorClass " + mapping.getComparatorClass() + " for " + mapping.getColumnClass(), e1);
                }
            }
            if (pColumnForInitialSorting >= 0 && pColumnForInitialSorting < sorter.getColumnCount()) {
                sorter.forceInitialSorting(pColumnForInitialSorting);
            }
        }
        int n3 = pMapping.size();
        for (int i = 0; i < n3; ++i) {
            ListTableMapper.Mapping mapping = pMapping.get(i);
            if (mapping.getColumnAlignment() != null) {
                pTable.getColumnModel().getColumn(i).setCellRenderer(new ColumnAlignmentRenderer(mapping.getColumnAlignment()));
            } else if (mapping.getColumnClass() != null && Boolean.class.isAssignableFrom(mapping.getColumnClass())) {
                pTable.getColumnModel().getColumn(i).setCellRenderer(new ColumnAlignmentRenderer("center"));
            } else if (mapping.getColumnClass() != null && (Number.class.isAssignableFrom(mapping.getColumnClass()) || Date.class.isAssignableFrom(mapping.getColumnClass()))) {
                pTable.getColumnModel().getColumn(i).setCellRenderer(new ColumnAlignmentRenderer("right"));
            } else {
                pTable.getColumnModel().getColumn(i).setCellRenderer(new ColumnAlignmentRenderer("left"));
            }
            if (mapping.getColumnPrefWidthIntValue() <= 0) continue;
            pTable.setAutoResizeMode(0);
            JTextField dummyTextField = new JTextField(mapping.getColumnPrefWidthIntValue());
            pTable.getColumnModel().getColumn(i).setPreferredWidth(dummyTextField.getPreferredSize().width);
        }
    }

    @Override
    public int getColumnCount() {
        return this.mColumnMapping.size();
    }

    @Override
    public String getColumnName(int pColumnIndex) {
        return this.mColumnMapping.get(pColumnIndex).getColumnTitle();
    }

    @Override
    public Class<?> getColumnClass(int pColumnIndex) {
        Class<Object> clazz = this.mColumnMapping.get(pColumnIndex).getColumnClass();
        if (clazz == null) {
            clazz = Object.class;
        }
        return clazz;
    }

    @Override
    public Object getValueAt(int pRowIndex, int pColumnIndex) {
        ListTableMapper.Mapping mapping = this.mColumnMapping.get(pColumnIndex);
        DelegateAccess valueModel = mapping.getValueModel();
        Object list = this.mMultiSelectionInList.getValue();
        Object value = list.get(pRowIndex);
        Object back = valueModel.getValue(value);
        return back;
    }

    public Object getRawValueAt(int pRowIndex, int pColumnIndex) {
        Object list = this.mMultiSelectionInList.getValue();
        Object value = list.get(pRowIndex);
        return value;
    }

    public Object getValueForSortingAt(int pRowIndex, int pColumnIndex) {
        ListTableMapper.Mapping mapping = this.mColumnMapping.get(pColumnIndex);
        DelegateAccess valueModelForSorting = mapping.getValueModelForSorting();
        Object list = this.mMultiSelectionInList.getValue();
        Object value = list.get(pRowIndex);
        Object back = valueModelForSorting.getValue(value);
        return back;
    }

    public boolean isColumnSortable(int pColumnIndex) {
        ListTableMapper.Mapping mapping = this.mColumnMapping.get(pColumnIndex);
        return mapping.isSortable();
    }

    protected void setIndexConverter(IndexConverter pIndexConverter) {
        if (pIndexConverter == null) {
            throw new IllegalArgumentException("IndexConverter must not be null");
        }
        this.mIndexConverter = pIndexConverter;
        this.vmSelectionChanged(new ChangeEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vmDataChanged(ChangeEvent pEvent) {
        if (this.mInSelectionChange) {
            return;
        }
        this.mInSelectionChange = true;
        try {
            TableModelEvent e = new TableModelEvent(this);
            this.fireTableChanged(e);
            this.updateSelectionFromModel();
        }
        finally {
            this.mInSelectionChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vmSelectionChanged(ChangeEvent pEvent) {
        if (this.mInSelectionChange) {
            return;
        }
        this.mInSelectionChange = true;
        try {
            this.updateSelectionFromModel();
        }
        finally {
            this.mInSelectionChange = false;
        }
    }

    private void updateSelectionFromModel() {
        Set selectedIndexes = this.mMultiSelectionInList.getSelectedIndexSetValueModel().getValue();
        ListSelectionModel selectionModel = this.mTable.getSelectionModel();
        selectionModel.clearSelection();
        for (Object selectedIndexe : selectedIndexes) {
            Integer selectedIndex = (Integer)selectedIndexe;
            int viewIndex = this.mIndexConverter.convert2ViewIndex(selectedIndex);
            if (0 > viewIndex || viewIndex >= this.mTable.getRowCount()) continue;
            selectionModel.addSelectionInterval(viewIndex, viewIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent pEvent) {
        if (this.mInSelectionChange) {
            return;
        }
        if (pEvent.getValueIsAdjusting()) {
            return;
        }
        this.mInSelectionChange = true;
        try {
            HashSet<Integer> selectionIndexSet = new HashSet<Integer>((Set)this.mMultiSelectionInList.getSelectedIndexSetValueModel().getValue());
            int fromViewIndex = Math.max(0, pEvent.getFirstIndex());
            int toViewIndex = Math.min(this.mTable.getRowCount() - 1, pEvent.getLastIndex());
            if (fromViewIndex > toViewIndex) {
                fromViewIndex = 0;
                toViewIndex = this.mTable.getRowCount() - 1;
            }
            for (int checkIndex = fromViewIndex; checkIndex <= toViewIndex; ++checkIndex) {
                boolean selected = this.mTable.isRowSelected(checkIndex);
                int modelIndex = this.mIndexConverter.convert2ModelIndex(checkIndex);
                if (selected) {
                    selectionIndexSet.add(modelIndex);
                    continue;
                }
                selectionIndexSet.remove(modelIndex);
            }
            this.mMultiSelectionInList.setSelectedIndexes(selectionIndexSet);
        }
        finally {
            this.mInSelectionChange = false;
        }
    }

    @Override
    public int getRowCount() {
        Object list = this.mMultiSelectionInList.getValue();
        return list == null ? 0 : list.size();
    }

    @Override
    public boolean isCellEditable(int pRowIndex, int pColumnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object pValue, int pRowIndex, int pColumnIndex) {
        throw new UnsupportedOperationException("this is a read-only table model");
    }

    @Override
    public void addTableModelListener(TableModelListener pTableModelListener) {
        this.mListenerList.add(TableModelListener.class, pTableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener pTableModelListener) {
        this.mListenerList.remove(TableModelListener.class, pTableModelListener);
    }

    protected void fireTableChanged(TableModelEvent peEvent) {
        Object[] listeners = this.mListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(peEvent);
        }
    }
}

