/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.ui;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import net.sf.cuf.model.DelegateAccess;
import net.sf.cuf.model.MultiSelectionInList;

public class MultiSelectionListModelAdapter
implements ListModel,
ListSelectionModel {
    private EventListenerList mListenerList;
    private ListSelectionModel mListSelectionModel;
    private boolean mInSelectionChange;
    protected MultiSelectionInList mMultiSelectionInList;
    private DelegateAccess mAccessValueModel;

    public MultiSelectionListModelAdapter(JList pList, MultiSelectionInList pListValueModel, DelegateAccess pAccessValueModel) {
        if (pList == null) {
            throw new IllegalArgumentException("list must not be null");
        }
        if (pListValueModel == null) {
            throw new IllegalArgumentException("list value model must not be null");
        }
        this.mListSelectionModel = pList.getSelectionModel();
        this.mMultiSelectionInList = pListValueModel;
        this.mAccessValueModel = pAccessValueModel;
        this.mListenerList = new EventListenerList();
        this.mInSelectionChange = false;
        this.mMultiSelectionInList.onChangeSend(this, "vmDataChanged");
        this.mMultiSelectionInList.getSelectedIndexSetValueModel().onChangeSend(this, "vmSelectionChanged");
        pList.setModel(this);
        pList.setSelectionModel(this);
        this.vmSelectionChanged(null);
    }

    protected void fireListChanged(ListDataEvent pEvent) {
        Object[] listeners = this.mListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListDataListener.class) continue;
            ((ListDataListener)listeners[i + 1]).contentsChanged(pEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vmDataChanged(ChangeEvent pEvent) {
        this.mInSelectionChange = true;
        try {
            Object baseList = this.mMultiSelectionInList.getValue();
            int maxIndex = -1;
            if (baseList != null) {
                maxIndex = baseList.size() - 1;
            }
            ListDataEvent e = new ListDataEvent(this, 0, 0, maxIndex);
            this.fireListChanged(e);
            this.mListSelectionModel.setValueIsAdjusting(true);
            this.mListSelectionModel.clearSelection();
            for (Object o : (Set)this.mMultiSelectionInList.getSelectedIndexSetValueModel().getValue()) {
                Integer selectedIndex = (Integer)o;
                this.mListSelectionModel.addSelectionInterval(selectedIndex, selectedIndex);
            }
            this.mListSelectionModel.setValueIsAdjusting(false);
        }
        finally {
            this.mInSelectionChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vmSelectionChanged(ChangeEvent pEvent) {
        if (this.mInSelectionChange) {
            return;
        }
        this.mInSelectionChange = true;
        try {
            this.mListSelectionModel.setValueIsAdjusting(true);
            this.mListSelectionModel.clearSelection();
            for (Object o : (Set)this.mMultiSelectionInList.getSelectedIndexSetValueModel().getValue()) {
                Integer selectedIndex = (Integer)o;
                this.mListSelectionModel.addSelectionInterval(selectedIndex, selectedIndex);
            }
            this.mListSelectionModel.setValueIsAdjusting(false);
        }
        finally {
            this.mInSelectionChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleListSelection() {
        if (this.mInSelectionChange) {
            return;
        }
        if (this.mListSelectionModel.getValueIsAdjusting()) {
            return;
        }
        this.mInSelectionChange = true;
        try {
            HashSet<Integer> selectedIndexes = new HashSet<Integer>();
            for (int i = this.mListSelectionModel.getMinSelectionIndex(); i <= this.mListSelectionModel.getMaxSelectionIndex(); ++i) {
                if (!this.mListSelectionModel.isSelectedIndex(i)) continue;
                selectedIndexes.add(i);
            }
            this.mMultiSelectionInList.setSelectedIndexes(selectedIndexes);
        }
        finally {
            this.mInSelectionChange = false;
        }
    }

    @Override
    public void setSelectionInterval(int pIndex0, int pIndex1) {
        this.mListSelectionModel.setSelectionInterval(pIndex0, pIndex1);
        this.handleListSelection();
    }

    @Override
    public void addSelectionInterval(int pIndex0, int pIndex1) {
        this.mListSelectionModel.addSelectionInterval(pIndex0, pIndex1);
        this.handleListSelection();
    }

    @Override
    public void removeSelectionInterval(int pIndex0, int pIndex1) {
        this.mListSelectionModel.removeSelectionInterval(pIndex0, pIndex1);
        this.handleListSelection();
    }

    @Override
    public void insertIndexInterval(int pIndex, int pLength, boolean pBefore) {
        this.mListSelectionModel.insertIndexInterval(pIndex, pLength, pBefore);
        this.handleListSelection();
    }

    @Override
    public void removeIndexInterval(int pIndex0, int pIndex1) {
        this.mListSelectionModel.removeIndexInterval(pIndex0, pIndex1);
        this.handleListSelection();
    }

    @Override
    public void clearSelection() {
        this.mListSelectionModel.clearSelection();
        this.handleListSelection();
    }

    @Override
    public int getMinSelectionIndex() {
        return this.mListSelectionModel.getMinSelectionIndex();
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.mListSelectionModel.getMaxSelectionIndex();
    }

    @Override
    public boolean isSelectedIndex(int pIndex) {
        if (pIndex == -1) {
            return false;
        }
        return this.mListSelectionModel.isSelectedIndex(pIndex);
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.mListSelectionModel.getAnchorSelectionIndex();
    }

    @Override
    public void setAnchorSelectionIndex(int pIndex) {
        this.mListSelectionModel.setAnchorSelectionIndex(pIndex);
        this.handleListSelection();
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.mListSelectionModel.getLeadSelectionIndex();
    }

    @Override
    public void setLeadSelectionIndex(int pIndex) {
        this.mListSelectionModel.setLeadSelectionIndex(pIndex);
        this.handleListSelection();
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.mListSelectionModel.isSelectionEmpty();
    }

    @Override
    public void setValueIsAdjusting(boolean pValueIsAdjusting) {
        if (pValueIsAdjusting != this.mListSelectionModel.getValueIsAdjusting()) {
            this.mListSelectionModel.setValueIsAdjusting(pValueIsAdjusting);
            this.handleListSelection();
        }
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.mListSelectionModel.getValueIsAdjusting();
    }

    @Override
    public void setSelectionMode(int pSelectionMode) {
        this.mListSelectionModel.setSelectionMode(pSelectionMode);
    }

    @Override
    public int getSelectionMode() {
        return this.mListSelectionModel.getSelectionMode();
    }

    @Override
    public void addListSelectionListener(ListSelectionListener pListener) {
        this.mListSelectionModel.addListSelectionListener(pListener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener pListener) {
        this.mListSelectionModel.removeListSelectionListener(pListener);
    }

    public Object getElementAt(int pIndex) {
        if (pIndex == -1) {
            return null;
        }
        Object list = this.mMultiSelectionInList.getValue();
        Object value = list.get(pIndex);
        if (this.mAccessValueModel != null) {
            value = this.mAccessValueModel.getValue(value);
        }
        return value;
    }

    @Override
    public int getSize() {
        if (this.mMultiSelectionInList.getValue() != null) {
            return this.mMultiSelectionInList.getValue().size();
        }
        return 0;
    }

    @Override
    public void addListDataListener(ListDataListener pListener) {
        this.mListenerList.add(ListDataListener.class, pListener);
    }

    @Override
    public void removeListDataListener(ListDataListener pListener) {
        this.mListenerList.remove(ListDataListener.class, pListener);
    }
}

