/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class LOVCellEditor
extends DefaultCellEditor
implements TableCellRenderer {
    private List<?> mKeys;
    private JComboBox mRenderer;

    public LOVCellEditor(List<?> pKeys, List<?> pDisplayedItems) {
        super(new JComboBox());
        if (pKeys == null) {
            throw new IllegalArgumentException("Keys must not be null");
        }
        if (pDisplayedItems == null) {
            throw new IllegalArgumentException("DisplayedItems must not be null");
        }
        if (pKeys.size() != pDisplayedItems.size()) {
            throw new IllegalArgumentException("size of Keys and DisplayedItems must match");
        }
        final JComboBox comboBox = (JComboBox)this.editorComponent;
        comboBox.removeActionListener(this.delegate);
        this.delegate = null;
        comboBox.setModel(new DefaultComboBoxModel<Object>(pDisplayedItems.toArray()));
        this.mRenderer = new JComboBox<Object>(pDisplayedItems.toArray());
        this.mKeys = new ArrayList(pKeys);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object pValue) {
                int index = LOVCellEditor.this.mKeys.indexOf(pValue);
                comboBox.setSelectedIndex(index);
            }

            @Override
            public Object getCellEditorValue() {
                int index = comboBox.getSelectedIndex();
                if (index == -1) {
                    return null;
                }
                return LOVCellEditor.this.mKeys.get(index);
            }

            @Override
            public boolean shouldSelectCell(EventObject pEvent) {
                if (pEvent instanceof MouseEvent) {
                    MouseEvent e = (MouseEvent)pEvent;
                    return e.getID() != 506;
                }
                return true;
            }

            @Override
            public boolean stopCellEditing() {
                if (comboBox.isEditable()) {
                    comboBox.actionPerformed(new ActionEvent(LOVCellEditor.this, 0, ""));
                }
                return super.stopCellEditing();
            }
        };
        comboBox.addActionListener(this.delegate);
    }

    @Override
    public Component getTableCellRendererComponent(JTable pTable, Object pValue, boolean pIsSelected, boolean pHasFocus, int pRow, int pColumn) {
        int index = this.mKeys.indexOf(pValue);
        this.mRenderer.setSelectedIndex(index);
        return this.mRenderer;
    }
}

