/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.state;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.state.AbstractState;

public class RegExpState
extends AbstractState
implements ChangeListener {
    private ValueModel<?> mTrigger;
    private Pattern mPattern;

    public RegExpState(ValueModel<?> pTrigger, String pRegExpr) {
        if (pTrigger == null) {
            throw new IllegalArgumentException("pTrigger must not be null");
        }
        if (pRegExpr == null) {
            throw new IllegalArgumentException("pRegExpr must not be null");
        }
        this.mTrigger = pTrigger;
        this.mPattern = Pattern.compile(pRegExpr);
        this.mIsInitialized = true;
        this.mTrigger.addChangeListener(this);
        this.checkTriggerValue();
    }

    @Override
    public void stateChanged(ChangeEvent pE) {
        this.checkTriggerValue();
    }

    private void checkTriggerValue() {
        boolean newIsEnabled = false;
        Object value = this.mTrigger.getValue();
        if (value instanceof CharSequence) {
            Matcher matcher = this.mPattern.matcher((CharSequence)value);
            newIsEnabled = matcher.matches();
        }
        if (newIsEnabled != this.mIsEnabled) {
            this.mIsEnabled = newIsEnabled;
            this.fireStateChanged();
        }
    }
}

