/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.state;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.cuf.model.ValueHolder;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.state.AbstractState;

public class EqualsState
extends AbstractState
implements ChangeListener {
    private ValueModel<?> mTrigger1;
    private ValueModel<?> mTrigger2;

    public EqualsState(ValueModel<?> pTrigger, Object pReferenceValue) {
        this(pTrigger, new ValueHolder<Object>(pReferenceValue));
    }

    public EqualsState(ValueModel<?> pTrigger1, ValueModel<?> pTrigger2) {
        if (pTrigger1 == null) {
            throw new IllegalArgumentException("first trigger value model must not be null");
        }
        if (pTrigger2 == null) {
            throw new IllegalArgumentException("second trigger value model must not be null");
        }
        this.mTrigger1 = pTrigger1;
        this.mTrigger2 = pTrigger2;
        this.mIsInitialized = true;
        this.mTrigger1.addChangeListener(this);
        this.mTrigger2.addChangeListener(this);
        this.computeState();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (!this.mTrigger1.isDisposed()) {
            this.mTrigger1.removeChangeListener(this);
        }
        if (!this.mTrigger2.isDisposed()) {
            this.mTrigger2.removeChangeListener(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent pEvent) {
        this.computeState();
    }

    private void computeState() {
        Object value2;
        Object value1 = this.mTrigger1.getValue();
        if (value1 == (value2 = this.mTrigger2.getValue())) {
            this.internalSetEnabled(true);
        } else if (value1 == null) {
            this.internalSetEnabled(false);
        } else if (value1.equals(value2)) {
            this.internalSetEnabled(true);
        } else {
            this.internalSetEnabled(false);
        }
    }

    private void internalSetEnabled(boolean pEnabled) {
        if (this.mIsEnabled != pEnabled) {
            this.mIsEnabled = pEnabled;
            this.fireStateChanged();
        }
    }
}

