/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.converter;

import net.sf.cuf.model.ValueModel;
import net.sf.cuf.model.converter.AbstractTypeConverter;
import net.sf.cuf.model.converter.ConversionException;
import net.sf.cuf.model.converter.TypeConverter;

public abstract class AbstractNumberStringConverter<T extends Number>
extends AbstractTypeConverter<String, T>
implements TypeConverter<String, T> {
    private boolean mNullIsValid;
    private Number mNullSubstitute;

    public AbstractNumberStringConverter(ValueModel<T> pSubject) {
        this(pSubject, true);
    }

    public AbstractNumberStringConverter(ValueModel<T> pSubject, boolean pNullIsValid) {
        super(pSubject);
        this.mNullIsValid = pNullIsValid;
        this.mNullSubstitute = null;
    }

    public void setNullIsValid(boolean pNullIsValid) {
        this.mNullIsValid = pNullIsValid;
    }

    public boolean getNullIsValid() {
        return this.mNullIsValid;
    }

    public void setNullSubstitute(Number pNullSubstitute) {
        if (!this.mNullIsValid) {
            throw new IllegalStateException("null substitute " + pNullSubstitute + " set but null is not valid at all");
        }
        this.mNullSubstitute = pNullSubstitute;
    }

    @Override
    public String convertSubjectToOwnValue(T pSubjectValue) throws ConversionException {
        if (pSubjectValue == null) {
            if (this.mNullIsValid) {
                throw new ConversionException("Number subject is null", null, null);
            }
            throw new ConversionException("Number subject is null and !mNullIsValid", null);
        }
        String ownValue = this.convertToString((Number)pSubjectValue);
        return ownValue;
    }

    protected String convertToString(Number pSubjectValue) {
        return pSubjectValue.toString();
    }

    @Override
    public T convertOwnToSubjectValue(String pOwnValue) throws ConversionException {
        T subjectValue;
        try {
            subjectValue = this.convertToNumber(pOwnValue);
        }
        catch (Exception e) {
            if (this.mNullIsValid) {
                throw new ConversionException(e.getMessage(), e, this.mNullSubstitute);
            }
            throw new ConversionException(e.getMessage(), e);
        }
        return subjectValue;
    }

    protected abstract T convertToNumber(String var1) throws NumberFormatException;
}

