/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model;

import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.cuf.model.AbstractValueModel;
import net.sf.cuf.model.AspectAccessAdapter;
import net.sf.cuf.model.DelegateAccess;
import net.sf.cuf.model.ExternalUpdate;
import net.sf.cuf.model.MixedAccessAdapter;
import net.sf.cuf.model.ValueModel;

public class AspectAdapter<T, S>
extends AbstractValueModel<T>
implements ValueModel<T>,
ChangeListener,
DelegateAccess,
ExternalUpdate {
    public static final String SEPARATOR = ".";
    private ValueModel<? extends S> mTrigger;
    private ExternalUpdate mTriggerUpdate;
    private Object mSource;
    private String mAspectName;
    private Class<S> mSourceClass;
    private AspectAccessAdapter mAccessAdapter;
    public static final String GET = "get";
    public static final String SET = "set";

    public static AspectAdapter<?, ?> getShared(ValueModel<?> pTrigger, String pAspectName) {
        if (pTrigger == null) {
            throw new IllegalArgumentException("trigger must not be null");
        }
        AspectAdapter back = null;
        if (pTrigger instanceof AbstractValueModel) {
            AbstractValueModel trigger = (AbstractValueModel)pTrigger;
            List<Object> dependents = trigger.getDependents();
            for (Object dependent : dependents) {
                AspectAdapter aspectAdapter;
                if (!(dependent instanceof AspectAdapter) || !(aspectAdapter = (AspectAdapter)dependent).getAspectName().equals(pAspectName)) continue;
                back = aspectAdapter;
                break;
            }
        }
        if (back == null) {
            back = new AspectAdapter(pTrigger, pAspectName);
        }
        return back;
    }

    public AspectAdapter(ValueModel<S> pTrigger, String pAspectName) {
        this(pTrigger, pAspectName, GET, SET);
    }

    public AspectAdapter(ValueModel<S> pTrigger, String pAspectName, String pGetterPrefix, String pSetterPrefix) {
        S source;
        if (pTrigger == null) {
            throw new IllegalArgumentException("trigger must not be null");
        }
        this.init(source, (source = pTrigger.getValue()) == null ? null : source.getClass(), null, pTrigger, pAspectName, pGetterPrefix, pSetterPrefix);
    }

    public AspectAdapter(ValueModel<S> pTrigger, Class<S> pSourceClass, String pAspectName) {
        this(pTrigger, pSourceClass, null, pAspectName, GET, SET);
    }

    public AspectAdapter(ValueModel<S> pTrigger, Class<S> pSourceClass, String pAspectName, String pGetterPrefix, String pSetterPrefix) {
        this(pTrigger, pSourceClass, null, pAspectName, pGetterPrefix, pSetterPrefix);
    }

    public AspectAdapter(ValueModel<S> pTrigger, Class<S> pSourceClass, AspectAccessAdapter pAccessAdapter, String pAspectName) {
        this(pTrigger, pSourceClass, pAccessAdapter, pAspectName, GET, SET);
    }

    public AspectAdapter(ValueModel<S> pTrigger, Class<S> pSourceClass, AspectAccessAdapter pAccessAdapter, String pAspectName, String pGetterPrefix, String pSetterPrefix) {
        if (pTrigger == null) {
            throw new IllegalArgumentException("trigger must not be null");
        }
        this.init(pTrigger.getValue(), pSourceClass, pAccessAdapter, pTrigger, pAspectName, pGetterPrefix, pSetterPrefix);
    }

    public AspectAdapter(S pSource, String pAspectName) {
        if (pSource == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        this.init(pSource, pSource.getClass(), null, null, pAspectName, GET, SET);
    }

    public AspectAdapter(S pSource, String pAspectName, String pGetterPrefix, String pSetterPrefix) {
        if (pSource == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        this.init(pSource, pSource.getClass(), null, null, pAspectName, pGetterPrefix, pSetterPrefix);
    }

    private void init(Object pSource, Class<S> pSourceClass, AspectAccessAdapter pAccessAdapter, ValueModel<? extends S> pTrigger, String pAspectName, String pGetterPrefix, String pSetterPrefix) {
        if (pAspectName == null || pAspectName.length() == 0) {
            throw new IllegalArgumentException("aspect string must not be null or empty");
        }
        this.mSource = pSource;
        this.mSourceClass = pSourceClass;
        this.mTrigger = pTrigger;
        this.setInSetValue(false, false);
        this.mTriggerUpdate = this.mTrigger instanceof ExternalUpdate ? (ExternalUpdate)((Object)this.mTrigger) : null;
        this.mAspectName = pAspectName;
        this.mAccessAdapter = pAccessAdapter != null ? pAccessAdapter : new MixedAccessAdapter(pSourceClass, pAspectName, pGetterPrefix, pSetterPrefix);
        if (this.mTrigger != null) {
            this.mTrigger.addChangeListener(this);
        }
    }

    public AspectAccessAdapter getAccessAdapter() {
        return this.mAccessAdapter;
    }

    public void setAccessAdapter(AspectAccessAdapter pAccessAdapter) {
        if (pAccessAdapter == null) {
            throw new IllegalArgumentException("pAccessAdapter must not be null");
        }
        this.mAccessAdapter = pAccessAdapter;
    }

    @Override
    public boolean isEditable() {
        return this.mAccessAdapter.isEditable();
    }

    public String getAspectName() {
        return this.mAspectName;
    }

    public ValueModel<? extends S> getTrigger() {
        return this.mTrigger;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.mTrigger != null && !this.mTrigger.isDisposed()) {
            this.mTrigger.removeChangeListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(T pValue, boolean pIsSetForced) {
        this.checkDisposed();
        if (!this.isEditable()) {
            throw new UnsupportedOperationException("value not mutable (" + this.mSourceClass + ", aspect: " + this.mAspectName + ')');
        }
        if (this.mSource == null) {
            return;
        }
        try {
            this.setInSetValue(true, pIsSetForced);
            this.mAccessAdapter.setValue(this.mSource, pValue);
            if (this.mTriggerUpdate != null) {
                this.mTriggerUpdate.signalExternalUpdate();
            }
            this.fireStateChanged();
        }
        finally {
            this.setInSetValue(false, false);
        }
    }

    @Override
    public T getValue() {
        this.checkDisposed();
        return (T)this.mAccessAdapter.getValue(this.mSource);
    }

    @Override
    public Object getValue(Object pValue) {
        Object value = pValue;
        if (this.mTrigger instanceof DelegateAccess) {
            value = ((DelegateAccess)((Object)this.mTrigger)).getValue(pValue);
        }
        return this.mAccessAdapter.getValue(value);
    }

    @Override
    public void signalExternalUpdate() {
        if (this.mTrigger instanceof ExternalUpdate) {
            ((ExternalUpdate)((Object)this.mTrigger)).signalExternalUpdate();
        } else {
            super.signalExternalUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent pEvent) {
        this.checkDisposed();
        if (this.isInSetValue()) {
            return;
        }
        S newValue = this.mTrigger.getValue();
        boolean isSetForced = this.mTrigger.isSetForced();
        if (!isSetForced && (newValue == null && this.mSource == null || newValue == this.mSource)) {
            return;
        }
        if (newValue != null && this.mSourceClass != null && !this.mSourceClass.isAssignableFrom(newValue.getClass())) {
            throw new IllegalStateException("new value has wrong type (expected: " + this.mSourceClass + ", found: " + newValue.getClass() + ')');
        }
        this.mSource = newValue;
        try {
            this.setInSetValue(false, isSetForced);
            this.fireStateChanged();
        }
        finally {
            this.setInSetValue(false, false);
        }
    }
}

